#include "ArchFullBypassTestResult.h"
#include "ArchivingManager.h"
#include <TFile.h>
#include <TKey.h>
#include <TDirectory.h>
#include <TSystem.h>
#include <TNamed.h>
#include <TObject.h>
#include <TObjArray.h>
#include <TString.h>
#include <TObjString.h>
#include <TVector.h>
#include <TVectorD.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TROOT.h>
#include <is/isinfo.h>
#include <iostream>
#include <vector>
#include <boost/shared_ptr.hpp>
#include "SummaryWriter/SummaryWriter.h"
#include "SummaryWriter/SummaryManager.h"



bool ArchFullBypassTestResult::inMap = ArchivingManager::instance().addTestArchiver("SctData::FullBypassTestResult", shared_ptr<ArchTestResult>(new ArchFullBypassTestResult()));  

/***********************  Constructor  *************** */

ArchFullBypassTestResult::ArchFullBypassTestResult(): ArchTestResult()  {

  //cout<< "I am in the ArchFullBypassTestResult Default Constructor"<< endl;
  
  
  
}


ArchFullBypassTestResult::ArchFullBypassTestResult(shared_ptr<FullBypassTestResult> FBtest): ArchTestResult(FBtest)  {

  //cout<< "I am in the ArchFullBypassTestResult Constructor"<< endl;
  
  /*--- Initialisation ---*/

  for (unsigned int i = 0; i<12;i++) { 
    //*----status_direct:
    status_direct.push_back(FBtest->getChipResult(i).status_direct);
    shared_ptr<TVector> tmp_v_status_direct (new TVector(1,1,FBtest->getChipResult(i).status_direct,"END"));
    v_status_direct.push_back(tmp_v_status_direct);


    //*----vdd_direct:
    vdd_direct.push_back(FBtest->getChipResult(i).vdd_direct);
    shared_ptr<TVector> tmp_v_vdd_direct (new TVector(1,1,FBtest->getChipResult(i).vdd_direct,"END"));
    v_vdd_direct.push_back(tmp_v_vdd_direct);
   


    //*----status_bypass:
    status_bypass.push_back(FBtest->getChipResult(i).status_bypass);
    shared_ptr<TVector> tmp_v_status_bypass (new TVector(1,1,FBtest->getChipResult(i).status_bypass,"END"));
    v_status_bypass.push_back(tmp_v_status_bypass);
   

    //*----vdd_bypass:
    vdd_bypass.push_back(FBtest->getChipResult(i).vdd_bypass);
    shared_ptr<TVector> tmp_v_vdd_bypass (new TVector(1,1,FBtest->getChipResult(i).vdd_bypass,"END"));
    v_vdd_bypass.push_back(tmp_v_vdd_bypass);
   


  }


     



  //Retrieve Test Summary from IS
  try{
    TestSummary(FBtest);
  } catch(...) {
    cout<<" ERROR in retrieving Test Summary from IS" <<endl;
  }



}



/**********************  Other Member Functions  *********************/


ArchFullBypassTestResult::~ArchFullBypassTestResult()  {
  
  //cout << "I am in the ArchFullBypassTestResult destructor" << endl;
  

  
}



void ArchFullBypassTestResult::SaveFullBypassTestDataOnly() {

  cout<<"Saving FullBypassTestData "<<endl;
  //TO DO : Save time and date of first and last saving  

  string filename = names->getfilename();
  string moduleID = names->getModuleID(); 
  string testType  = names->getTestType(); 
  string runID = names->getRunID();
  string status_directID = names->getStatus_directID();
  string vdd_directID = names->getVdd_directID();
  string status_bypassID = names->getStatus_bypassID();
  string vdd_bypassID = names->getVdd_bypassID();


  
  /* OPENING TEST FILE  */
  //cout << "Opening file..."<<endl; 
 
  TFile *storage_file = new TFile(filename.c_str(),"update");
  //storage_file->ls();
  //cout << "The file .root succesfully open"<<endl; 

  


  /* CREATING DIRECTORIES and SAVING DATA  */
  
    
    /* Making RunNumber   */
    //cout<<"I am making RunNumber Dir"<<endl;
    //storage_file->GetListOfKeys()->Print();
    TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str());
    //cout<<"The RUN is "<< runID <<endl;
    
    if (!this_run) {
      //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
      this_run = storage_file->mkdir(runID.c_str());
      //cout<<"New RunNumber Dir made "<<endl;
    }
    storage_file->GetListOfKeys()->Print();
    this_run->cd();  //make this_run the current directory
    
   
    /* Saving RunNumber as a TVector: it is saved only once, just the first time   */
    TObject* pers_runnumber = gDirectory->FindObjectAny(runID.c_str()); 
    if (!pers_runnumber) {
      double frunNumber = runNumber;
      TVector run(1,1,frunNumber, "END");
      run.Write(runID.c_str());
    }
    
    
    /* Making moduleNumber   */
    
    TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
    //cout<<"The MODULE is "<< moduleID <<endl;
    if (!this_module) {
      //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
      this_module =gDirectory ->mkdir(moduleID.c_str());
    }
    
    
    /* Making TestType   */
    //cout<<"I am making TestType Dir "<<endl;
    this_module->cd();  //make this_module the current directory 
    TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
    //cout<<"The test Type is "<< testType <<endl;
    
    if (!this_testType) {
      //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
      this_testType = gDirectory->mkdir(testType.c_str());
    }
    this_testType->cd();


    
    
    /* Saving status_direct, vdd_direct, status_bypass and  vdd_bypass  as a TVector */
    for (unsigned int i = 0; i<12;i++) {
      string chipN = names->getFBChipN(i);
      TDirectory* this_chipN = (TDirectory*) gDirectory->Get(chipN.c_str()); 
      //cout<<"The CHIP N is "<< chipN <<endl;
      if (!this_chipN) {
	//cout<<"This NEW CHIP "<< chipN.c_str() <<" doesn't exist"<<endl;
	this_chipN =gDirectory ->mkdir(chipN.c_str());
      }
      this_chipN->cd();  //make this_chipN the current directory 
      
      v_status_direct[i].get()->Write(status_directID.c_str());
      v_vdd_direct[i].get()->Write(vdd_directID.c_str());
      v_status_bypass[i].get()->Write(status_bypassID.c_str());
      v_vdd_bypass[i].get()->Write(vdd_bypassID.c_str());
      
      //gDirectory->cd("../");
      this_testType->cd();
    }

    

    //Save TestSummery (if it has been retrieved)
    if(testSummary != NULL) {
      //cout<<"testSummary != NULL...";
      TObject* pers_testSummary = gDirectory->FindObjectAny(names->getTestSummaryID().c_str());
      if (!pers_testSummary) {
	testSummary->Write(names->getTestSummaryID().c_str());
	//cout<<"testSummary SAVED"<<endl;
      }
    }
   




    /* CLOSING FILE  */
    //cout << "I am Closing File " << endl;
    storage_file->Close();
    delete storage_file;
    //cout << "File closed " << endl;




}





void ArchFullBypassTestResult::Save() {

  ArchTestResult::Save();
  SaveFullBypassTestDataOnly();
  //SaveRawScans();
  //SaveFitScans();
  AddTestToIndex();

}



void ArchFullBypassTestResult::TestSummary(shared_ptr<FullBypassTestResult> FBtest) {
  
  ostringstream datastream;
  shared_ptr<const SctData::TestSummary::SummaryWriter> writer = 
    SctData::TestSummary::SummaryManager::instance().getWriter(FBtest->getClassName());
  writer->writeHeader(*(FBtest.get()), datastream);
  writer->write(*(FBtest.get()), datastream);
  string myString = datastream.str();
  //cout<< "TestSummary = " << myString;

  testSummary = new TObjString(myString.c_str());

  


  return;


}

