#include "ArchFitScanResult.h"
#include "ArchivingManager.h"
#include <TFile.h>
#include <TKey.h>
#include <TDirectory.h>
#include <TSystem.h>
#include <TNamed.h>
#include <TObject.h>
#include <TObjArray.h>
#include <TString.h>
#include <TObjString.h>
#include <TVector.h>
#include <TVectorD.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TROOT.h>
#include <is/isinfo.h>
#include <iostream>
#include <vector>



/********************************** ArchScan Methods Definitions ************************/
/*
shared_ptr<ArchScanResult> ArchFitScanResult::CreateMap(shared_ptr<const FitScanResult>  fit) {
  shared_ptr<ArchScanResult> map = shared_ptr<ArchScanResult> (new ArchFitScanResult(fit));
  //map->SetFitScan(fit); 
  bool result =  ArchivingManager::instance().addScanArchiver("SctData::FitScanResult", map);  
 
  return map;
 

}
*/

bool ArchFitScanResult::inMap = ArchivingManager::instance().addScanArchiver("SctData::FitScanResult", shared_ptr<ArchScanResult>(new ArchFitScanResult())); 

/***********************  Constructor  *************** */

ArchFitScanResult::ArchFitScanResult():  ArchScanResult()  {

  //cout<< "I am in the ArchFitScanResult Default Constructor"<< endl;
  
}
  
  
ArchFitScanResult::ArchFitScanResult(shared_ptr<const FitScanResult> fit):  ArchScanResult(fit) {

  cout<< "I am in the ArchFitScanResult Constructor"<< endl;

  /*--- Initialisation ---*/
  theFit=fit;
  //theFit = new FitScanResult(fit);
          
  //ArchFitScanResult::inMap();


}







/**********************  Other Member Functions  *********************/

ArchFitScanResult::~ArchFitScanResult() {
  
  cout << "I am in the ArchFitScanResult() destructor" << endl;
  //delete theFit;
  
}





void ArchFitScanResult::SetFitScan(shared_ptr<const FitScanResult> fit)  {
  
  /*--- Initialisation ---*/
  //shared_ptr<const ScanResult> tmp_fitscan = shared_ptr<const ScanResult> (fit);
  SetScan(fit);
  //SetFitScan(tmp_fitscan);
  theFit=fit;
  //theFit =  new FitScanResult(fit);




}


void ArchFitScanResult::SaveFitScan() {  



  //TO DO : Save time and date of first and last saving


  string ScanPointsID = names->getScanPointsID() ;
  string vpointsID = names->getvpointsID();
  string vNEventsID = names->getvNEventsID();
  string vNErrorEventsID = names->getvNErrorEventsID(); 
  string filename = names->getfilename();
  //string objName = ;  //To be deleted
  string variable = names->getVariable(); 
  string moduleID = names->getModuleID(); 
  string testType  = names->getTestType(); //????????
  string runID = names->getRunID();
  string scanID = names->getScanID();
  string RODID = names->getRODID();
  string DCSID = names->getDCSID();
  string RawID = names->getRawID();
  string FitID = names->getFitID();
  string ModuleConfigID = names->getModuleConfigID();
  string LinksID = names->getLinksID();
  string ChipsID = names->getChipsID();
  string ChannelsID = names->getChannelsID();
  //string TF1_AllLinkFits = names->getTF1_AllLinkFits();
  //string TF1_AllChipFits = names->getTF1_AllChipFits();
  //string TF1_AllChannelFits = names->getTF1_AllChannelFits();

 
  /* OPENING TEST FILE  */
  TFile *storage_file = new TFile(filename.c_str(),"update");
  //storage_file->ls();
  cout << "The file .root succesfully open"<<endl; 

  


  /* CREATING DIRECTORIES and SAVING DATA  */
  
    
    /* Making RunNumber   */
    cout<<"I am making RunNumber Dir"<<endl;
    //storage_file->GetListOfKeys()->Print();
    TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str());
    //cout<<"The RUN is "<< runID <<endl;
    
    if (!this_run) {
      //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
      this_run = storage_file->mkdir(runID.c_str());
      //cout<<"New RunNumber Dir made "<<endl;
    }
    //storage_file->GetListOfKeys()->Print();
    this_run->cd();  //make this_run the current directory 
    

    /* Saving RunNumber as a TVector: it is saved only once, just the first time   */
    /* Already saved in ArchScanResult
    TObject* pers_runnumber = gDirectory->FindObjectAny(runID.c_str()); 
    if (!pers_runnumber) {
      double frunNumber = runNumber;
      TVector run(1,1,frunNumber, "END");
      run.Write(runID.c_str());
    }
    */
    
    
    /* Making moduleNumber   */
    
    TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
    //cout<<"The MODULE is "<< moduleID <<endl;
    if (!this_module) {
      //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
      this_module =gDirectory ->mkdir(moduleID.c_str());
    }
    this_module->cd();  //make this_module the current directory
    
    
    /* Making TestType   */
    cout<<"I am making TestType Dir "<<endl;
    TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
    //cout<<"The test Type is "<< testType <<endl;
    
    if (!this_testType) {
      //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
      this_testType = gDirectory->mkdir(testType.c_str());
    }
    this_testType->cd();
    
    /* Making ConfigurationVariable   */
    cout<<"I am making testName Dir "<<endl;
    TDirectory* this_variable = (TDirectory*) gDirectory->Get(variable.c_str());
    //cout<<"The Scan Type is "<< variable <<endl;
    
    if (!this_variable) {
      //cout<<"This NEW Scan Type "<< variable <<" doesn't exist"<<endl;
      this_variable = gDirectory->mkdir(variable.c_str());
    }
     

    

    /* Making scanName   */
    //cout<<"I am making scanName Dir "<<endl;
    this_variable->cd();  //make this_test the current directory
    TDirectory* this_scan = (TDirectory*) gDirectory->Get(scanID.c_str());
    //cout<<"The SCAN is "<< scanID <<endl;
    
    if (!this_scan) {
      //cout<<"This NEW scan "<< scanID <<" doesn't exist"<<endl;
      this_scan =gDirectory ->mkdir(scanID.c_str());
    }
    this_scan->cd(); 
    
    /* Saving ScanNumber as a TVector: it is saved only once, just the first time   */
    /* Already saved in ArchScanResult    
    TObject* pers_scannumber = gDirectory->FindObjectAny(scanID.c_str());
    if (!pers_scannumber) {
      double fscanNumber = scanNumber;
      TVector vscan(1,1,fscanNumber,"END");
      vscan.Write(scanID.c_str());
    }
    */    

    
    //Saving Module Configuration
    /* Already saved in ArchScanResult
    TObject* pers_ModuleConfig = gDirectory->FindObjectAny(ModuleConfigID.c_str());
    if (!pers_ModuleConfig) {
      //cout<<"%%%%%%% Just about to save ABCDModule %%%%%%%"<<endl;
      TObjString ModuleConfigTObjString = getModuleConfigTObjString();
      //TString tmp_string = ModuleConfigTObjString.String();
      //cout<< "Module Configuration :" << endl << tmp_string.Data()<<endl;
      ModuleConfigTObjString.Write(ModuleConfigID.c_str()); 
      //cout<<"%%%%%%% ABCDModule saved %%%%%%%"<<endl;
    }
    */ 

    /* Threshold saved as a TVector:it is saved only once, just the first time */     
/*
    TObject* pers_Threshold = gDirectory->FindObjectAny("Threshold");  
    if (!pers_Threshold) {
      cout << "The Threshold never saved before...saving now"<<endl;
      double fthreshold = threshold;
      TVectorD vthreshold(1,1,fthreshold,"END");
      vthreshold.Write("Threshold");
    }
*/
    
    /* Saving ScanPoints as a TGraph: it is saved only once, just the first time */
    //cout << "I am Saving ScanPointss as a TGraph" << endl;
    /* Already saved in ArchScanResult
    this_scan->cd();
    TObject* pers_scanpoints = gDirectory->FindObjectAny(ScanPointsID.c_str()); 
    if (!pers_scanpoints) {
      //cout << "The ScanPoints never saved before...saving now"<<endl;
      gpoints->Write(ScanPointsID.c_str());
    }
    */

    /* Saving ScanPoints as a TVector: it is saved only once, just the first time  */
    /* Already saved in ArchScanResult
    //cout << "I am Saving ScanPoints as  TVector's" << endl;
    TObject* pers_vscanpoints = gDirectory->FindObjectAny(vpointsID.c_str()); 
    if (!pers_vscanpoints) {
      //cout << "The ScanPoints never saved before...saving now"<<endl;
      vpoints->Write(vpointsID.c_str());  
    }
    TObject* pers_vNEvents = gDirectory->FindObjectAny(vNEventsID.c_str()); 
    if (!pers_vNEvents) {
      vNEvents->Write(vNEventsID.c_str());   
    }
    TObject* pers_vNErrorEvents = gDirectory->FindObjectAny(vNErrorEventsID.c_str()); 
    if (!pers_vNErrorEvents) {
      vNErrorEvents->Write(vNErrorEventsID.c_str());  
    }
    */


    /* Making DCS   */
    /*
    //cout<<"I am making DCS Dir"<<endl;
    this_scan->cd();  //make this_scan the current directory
    TDirectory*  this_DCS = (TDirectory*) this_scan->Get(DCSID.c_str()); 
    //NB: DCS & ROD are at the same level. 
    if (!this_DCS) {
      //cout<<"This NEW DCS  doesn't exist"<<endl;
      this_DCS = this_scan->mkdir(DCSID.c_str());
    }
    
    */
   

    /* Saving DCS data members  */
    /*
    cout << "I am Saving DCS FitScanResult Data Members" << endl;
    this_DCS->cd();  
    */

    /* Making ROD   */ 
    cout<<"I am making ROD Dir"<<endl;
    this_scan->cd();  //make this_scan the current directory
    TDirectory* this_ROD = (TDirectory*) this_scan->Get(RODID.c_str());
    //NB: DCS & ROD are at the same level: this_scan .Get(DCSID.c_str())
     
    if (!this_ROD) {
      //cout<<"This NEW ROD  doesn't exist"<<endl;
      this_ROD = this_scan->mkdir(RODID.c_str());
    }
    
  
    
    /* Making ROD Fitted    */
    cout<<"I am making Fitted"<<endl;
    this_ROD->cd();  //make this_scan the current directory 
    TDirectory* this_fitted = (TDirectory*) this_ROD ->Get(FitID.c_str());
    /*NB: Fitted & Raw are at the same level: they can descend from DCS or ROD For this reason gDirectory.Get("...")*/
    if (!this_fitted) {
      //cout<<"This NEW Fitted Data  doesn't exist"<<endl;
      this_fitted = this_ROD->mkdir(FitID.c_str());
    }
    
  
    

    /* Saving ROD Fitted data members  */
    cout << "I am Saving ROD Fitted FitScanResult Data Members " << endl;
    this_fitted->cd();  //make this_scan the current directory 

    /* Saving Links */ 
    TDirectory* this_Links = (TDirectory*) this_fitted->Get(LinksID.c_str());
    if (!this_Links) {
      //cout<<"This NEW Links dir  doesn't exist"<<endl;
      this_Links = this_fitted->mkdir(LinksID.c_str());
    }
    this_Links->cd();

    for (unsigned i=0; i<theFit->getNLinkFits(); ++i){
	auto_ptr<TF1> f=theFit->getLinkFit(i).makeRootTF1();
	f->Write(names->getTF1_AllLinkFits(i).c_str());
    }

     

    /* Saving Chips */
    TDirectory* this_Chips = (TDirectory*) this_fitted->Get(ChipsID.c_str());
    if (!this_Chips) {
      //cout<<"This NEW Chips dir  doesn't exist"<<endl;
      this_Chips = this_fitted->mkdir(ChipsID.c_str());
    }
    this_Chips->cd();

    for (unsigned i=0; i<theFit->getNChipFits(); ++i){
	auto_ptr<TF1> f=theFit->getChipFit(i).makeRootTF1();
	f->Write(names->getTF1_AllChipFits(i).c_str());
    }

    
    /* Saving Channels */
    TDirectory* this_Channels = (TDirectory*) this_fitted->Get("Channels");
    if (!this_Channels) {
      //cout<<"This NEW Channels dir  doesn't exist"<<endl;
    this_Channels = this_fitted->mkdir("Channels");
    }
    this_Channels->cd();
    
    for (unsigned i=0; i<theFit->getNChannelFits(); ++i){
	auto_ptr<TF1> f=theFit->getChannelFit(i).makeRootTF1();
	f->Write(names->getTF1_AllChannelFits(i).c_str());
    }



    /* CLOSING FILE  */
    cout << "I am Closing File " << endl;
    storage_file->Close();
    delete storage_file;
    cout << "File closed " << endl;

}




void ArchFitScanResult::SaveFitScan(shared_ptr<const FitScanResult> s) {

   ArchFitScanResult tmp_receiver(s); 
   tmp_receiver.SaveFitScan();

}


void ArchFitScanResult::Save() {
  
  ArchScanResult::Save();
  SaveFitScan();

}


void ArchFitScanResult::Save(shared_ptr<const FitScanResult> s) {
  
  ArchFitScanResult tmp_receiver(s); 
  tmp_receiver.Save();

}


bool ArchFitScanResult::FitScanIsPersisted()  {

  /* Check if the current FitScanResult of the current Test has been persisted*/
  
  string ScanPointsID = names->getScanPointsID() ;
  string vpointsID = names->getvpointsID();
  string vNEventsID = names->getvNEventsID();
  string vNErrorEventsID = names->getvNErrorEventsID(); 
  string filename = names->getfilename();
  //string objName = ;  //To be deleted
  string variable = names->getVariable(); 
  string moduleID = names->getModuleID(); 
  string testType  = names->getTestType(); //????????
  string runID = names->getRunID();
  string scanID = names->getScanID();
  string RODID = names->getRODID();
  string DCSID = names->getDCSID();
  string RawID = names->getRawID();
  string FitID = names->getFitID();
  string thresholdID = names->getThresholdID();
  string LinksID = names->getLinksID();
  string ChipsID = names->getChipsID();
  string ChannelsID = names->getChannelsID();
  //string TF1_AllLinkFits = names->getTF1_AllLinkFits();
  //string TF1_AllChipFits = names->getTF1_AllChipFits();
  //string TF1_AllChannelFits = names->getTF1_AllChannelFits();

  
 
  
  TFile *inspect_file = new TFile(filename.c_str(),"read");
  if (inspect_file->IsZombie() == true) {
    cout << "The scan has not been saved in any file"<<endl; 
    return 1;
  }
  
  
  gDirectory->cd(runID.c_str());
  TDirectory* inspect_dir = (TDirectory*) gDirectory->Get(moduleID.c_str());
  if (!inspect_dir) {
      cout<<"The scan has NOT been saved...moduleID"<<endl;
      return 1;
  }
  gDirectory->cd(moduleID.c_str());


  TDirectory* pers_testType = (TDirectory*) gDirectory->Get(testType.c_str());
  if (!pers_testType) {
      cout<<"The scan has NOT been saved....testType"<<endl;
      return 1;
  }
  gDirectory->cd(testType.c_str());


  TDirectory* pers_variable = (TDirectory*) gDirectory->Get(variable.c_str());
  if (!pers_variable) {
      cout<<"The scan has NOT been saved....scanType"<<endl;
      return 1;
  }
  gDirectory->cd(variable.c_str());



  inspect_dir = (TDirectory*) gDirectory->Get(scanID.c_str());
  if (!inspect_dir) {
      cout<<"The scan has NOT been saved...scanID"<<endl;
      return 1;
  }
  gDirectory->cd(scanID.c_str());

  /*
  TObject* pers_Threshold = gDirectory->FindObjectAny(thresholdID.c_str()); 
  if (!pers_Threshold) {
    cout << "The RawScanResult has NOT been saved..thresholdID."<<endl;
    return 1;
  }
*/
  
  //Check if ScanPoints are saved as TGraph
  TObject* pers_RawTH1 = gDirectory->FindObjectAny(ScanPointsID.c_str()); 
  if (!pers_RawTH1) {
    cout << "The RawScanResult has NOT been saved...ScanPointsID"<<endl;
    return 1;
  }


  //Check if ScanPoints are saved as TVector's
  TObject* pers_points = gDirectory->FindObjectAny(vpointsID.c_str()); 
  if (!pers_points) {
    cout << "The RawScanResult has NOT been saved...ScanPoints"<<endl;
    return 1;
  }
  TObject* pers_Nevents = gDirectory->FindObjectAny(vNEventsID.c_str()); 
  if (!pers_Nevents) {
    cout << "The RawScanResult has NOT been saved...ScanPoints"<<endl;
    return 1;
  }
  TObject* pers_vNErrorEvents = gDirectory->FindObjectAny(vNErrorEventsID.c_str()); 
  if (!pers_vNErrorEvents) {
    cout << "The RawScanResult has NOT been saved...ScanPoints"<<endl;
    return 1;
  }



  gDirectory->cd(RODID.c_str());
  gDirectory->cd(FitID.c_str());

  
  cout << "Looking for persisted histograms in Fitted Data" << endl;
 
  //Check if Links have been persisted
  gDirectory->cd(LinksID.c_str());
  for (unsigned i=0; i<theFit->getNLinkFits(); ++i){
    TObject* pers_Link = gDirectory->FindObjectAny( names->getTF1_AllLinkFits(i).c_str()); 
    if (!pers_Link) {
      cout << "The FitScanResult has NOT been saved...Links"<<endl;
      return 1;
    }
  }

  //Check if Chips have been persisted
  gDirectory->cd("../");
  gDirectory->cd(ChipsID.c_str());
  //gDirectory->ls();
  for (unsigned i=0; i<theFit->getNChipFits(); ++i){
    TObject* pers_Chip = gDirectory->FindObjectAny( names->getTF1_AllChipFits(i).c_str()); 
    if (!pers_Chip) {
      cout << "The FitScanResult has NOT been saved...Chips"<<endl;
      return 1;
    }
  }

  
  //Check if Channels have been persisted
  gDirectory->cd("../");
  //gDirectory->ls();
  gDirectory->cd(ChannelsID.c_str());
  //gDirectory->ls();
  for (unsigned i=0; i<theFit->getNChannelFits(); ++i){
    TObject* pers_Channels = gDirectory->FindObjectAny( names->getTF1_AllChannelFits(i).c_str()); 
    if (!pers_Channels) {
      cout << "The FitScanResult has NOT been saved...Channels"<<endl;
      return 1;
    }
  }
  

  cout << "FitScanResult has been PERSISTED" << endl;
  return 0;


}




bool ArchFitScanResult::FitScanIsPersisted(shared_ptr<FitScanResult> fitdata)  {

  ArchFitScanResult temp_dir(fitdata);
  return temp_dir.FitScanIsPersisted();

}





bool ArchFitScanResult::FitScanIsPersisted(long scanNumber, long runNumber, string moduleName, const ConfigurationVariable& variable)  {

  /* Check if the current FitScanResult of the current Test has been persisted*/

  ArchScanNames *new_names= new ArchScanNames(runNumber,moduleName,scanNumber, variable); 

  string ScanPointsID = new_names->getScanPointsID() ;
  string vpointsID = new_names->getvpointsID();
  string vNEventsID = new_names->getvNEventsID();
  string vNErrorEventsID = new_names->getvNErrorEventsID(); 
  string filename = new_names->getfilename();
  //string objName = ;  //To be deleted
  string sVariable = new_names->getVariable(); //!!!!
  string moduleID = new_names->getModuleID(); 
  string testType  = new_names->getTestType(); 
  string runID = new_names->getRunID();
  string scanID = new_names->getScanID();
  string RODID = new_names->getRODID();
  string DCSID = new_names->getDCSID();
  string RawID = new_names->getRawID();
  string FitID =new_names->getFitID();
  string thresholdID = new_names->getThresholdID();
  string LinksID = new_names->getLinksID();
  string ChipsID = new_names->getChipsID();
  string ChannelsID = new_names->getChannelsID();
  //string TF1_AllLinkFits = new_names->getTF1_AllLinkFits();
  //string TF1_AllChipFits = new_names->getTF1_AllChipFits();
  //string TF1_AllChannelFits = new_names->getTF1_AllChannelFits();




  /* Variable initialisation */


  /* Opening File */
  TFile *inspect_file = new TFile(filename.c_str(),"read");
  if (inspect_file->IsZombie() == true) {
    cout << "The RawScanResult has NOT been saved in any file"<<endl; 
    return 1;
  }
  
  
  gDirectory->cd(runID.c_str());
  TDirectory* inspect_dir = (TDirectory*) gDirectory->Get(moduleID.c_str());
  if (!inspect_dir) {
      cout<<"The RawScanResult has NOT been saved...moduleID"<<endl;
      return 1;
  }
  gDirectory->cd(moduleID.c_str());


   TDirectory* inspect_testType = (TDirectory*) gDirectory->Get(testType.c_str());
  if (!inspect_testType) {
      cout<<"The RawScanResult has NOT been saved...testType"<<endl;
      return 1;
  }
  gDirectory->cd(testType.c_str());


   TDirectory* inspect_variable = (TDirectory*) gDirectory->Get(sVariable.c_str());
  if (!inspect_variable) {
      cout<<"The RawScanResult has NOT been saved...variable"<<endl;
      return 1;
  }
  gDirectory->cd(sVariable.c_str());


  inspect_dir = (TDirectory*) gDirectory->Get(scanID.c_str());
  if (!inspect_dir) {
      cout<<"The RawScanResult has NOT been saved...scanID"<<endl;
      return 1;
  }
  gDirectory->cd(scanID.c_str());
  
  /*
  TObject* pers_Threshold = gDirectory->FindObjectAny(thresholdID.c_str()); 
  if (!pers_Threshold) {
    cout << "The RawScanResult has NOT been saved..thresholdID."<<endl;
    return 1;
  }

*/
  //Check if ScanPoints are saved as TGraph
  TObject* pers_RawTH1 = gDirectory->FindObjectAny(ScanPointsID.c_str()); 
  if (!pers_RawTH1) {
    cout << "The RawScanResult has NOT been saved...ScanPointsID"<<endl;
    return 1;
  }
  
  //Check if ScanPoints are saved as TVector's
  TObject* pers_points = gDirectory->FindObjectAny(vpointsID.c_str()); 
  if (!pers_points) {
    cout << "The RawScanResult has NOT been saved...ScanPoints"<<endl;
    return 1;
  }
  TObject* pers_Nevents = gDirectory->FindObjectAny(vNEventsID.c_str()); 
  if (!pers_Nevents) {
    cout << "The RawScanResult has NOT been saved...ScanPoints"<<endl;
    return 1;
  }
  TObject* pers_vNErrorEvents = gDirectory->FindObjectAny(vNErrorEventsID.c_str()); 
  if (!pers_vNErrorEvents) {
    cout << "The RawScanResult has NOT been saved...ScanPoints"<<endl;
    return 1;
  }


  gDirectory->cd(RODID.c_str());
  gDirectory->cd(FitID.c_str());

  
  
  cout << "Looking for persisted histograms in Fitted Data" << endl;
 
  //Check if Links have been persisted
  gDirectory->cd(LinksID.c_str());
  for (unsigned i=0; i<2; ++i){  //TO BE TESTED!!!!!
    TObject* pers_Link = gDirectory->FindObjectAny(new_names->getTF1_AllLinkFits(i).c_str()); 
    if (!pers_Link) {
      cout << "The FitScanResult has NOT been saved...Links"<<endl;
      return 1;
    }
  }

  //Check if Chips have been persisted
  gDirectory->cd("../");
  gDirectory->cd(ChipsID.c_str());
  //gDirectory->ls();
  for (unsigned i=0; i<12; ++i){  //TO BE TESTED!!!!!
    TObject* pers_Chip = gDirectory->FindObjectAny(new_names->getTF1_AllChipFits(i).c_str()); 
    if (!pers_Chip) {
      cout << "The FitScanResult has NOT been saved...Chips"<<endl;
      return 1;
    }
  }

  
  //Check if Channels have been persisted
  gDirectory->cd("../");
  //gDirectory->ls();
  gDirectory->cd(ChannelsID.c_str());
  //gDirectory->ls();
  for (unsigned i=0; i<1536; ++i){  //TO BE TESTED!!!!!
    TObject* pers_Channels = gDirectory->FindObjectAny(new_names->getTF1_AllChannelFits(i).c_str()); 
    if (!pers_Channels) {
      cout << "The FitScanResult has NOT been saved...Channels"<<endl;
      return 1;                                                          //!!!!To uncomment
    }
  }
  cout << "FitScanResult has been PERSISTED" << endl;
  return 0;


}




FitScanResult* ArchFitScanResult::CreateFitScanResult() {
  
  
  string Pers_Modulename;

  if ( FitScanIsPersisted() == 0 ) //To be modified: retrieve histo's and data from file
  { 
      
      cout << "...creating new FitScanResult obj from persistency" << endl;
      //Add at the end of the Unique ID, after the ModuleName, the string "Persisted"
      int dot = Archheader->getModuleName().find('.');
      string Pers_ModuleID = Archheader->getModuleName().substr(0, dot).c_str();  
      Pers_Modulename = Pers_ModuleID + ".Persisted";
      
  

   } else {

     cout << "WARNING: the FitScanResult has NOT been persisted!!" <<endl;
     //Add at the end of the Unique ID, after the ModuleName, the string "Persisted"
     int dot = Archheader->getModuleName().find('.');
     string Pers_ModuleID = Archheader->getModuleName().substr(0, dot).c_str();   
     Pers_Modulename = Pers_ModuleID + ".Unpersisted";
     
     
   }


  ScanHeader s(scanNumber, runNumber, Pers_Modulename , *Archvariable);
  FitScanResult* f = new FitScanResult(s, *ArchmoduleConfig, *Archpoints) ;
  //cout<< f->getHeader().getModuleName()<<endl;
  return f;  //NB: it could be =NULL if Unpersisted, as it is later 


}


FitScanResult* ArchFitScanResult::CreateFitScanResult(shared_ptr<FitScanResult> fit) {

  ArchFitScanResult tmp_createFit(fit);
  return tmp_createFit.CreateFitScanResult();

}





FitScanResult* ArchFitScanResult::CreateFitScanResult(long scanNumber, long runNumber, string moduleName, const ConfigurationVariable& variable) {
  
  
  string Pers_Modulename;
  ModuleConfiguration m;
  //ScanPoints pts;
  vector<TH1D*> new_FitData;

  ArchScanNames *new_names= new ArchScanNames(runNumber,moduleName,scanNumber, variable); 

  string ScanPointsID = new_names->getScanPointsID() ;
  string vpointsID = new_names->getvpointsID();
  string vNEventsID = new_names->getvNEventsID();
  string vNErrorEventsID = new_names->getvNErrorEventsID(); 
  string filename = new_names->getfilename();
  //string objName = ;  //To be deleted
  string sVariable = new_names->getVariable(); //!!!!
  string moduleID = new_names->getModuleID(); 
  string testType  = new_names->getTestType(); 
  string runID = new_names->getRunID();
  string scanID = new_names->getScanID();
  string RODID = new_names->getRODID();
  string DCSID = new_names->getDCSID();
  string RawID = new_names->getRawID();
  string FitID = new_names->getFitID();
  string thresholdID = new_names->getThresholdID();
  string LinksID = new_names->getLinksID();
  string ChipsID = new_names->getChipsID();
  string ChannelsID = new_names->getChannelsID();
  //string TF1_AllLinkFits = new_names->getTF1_AllLinkFits();
  //string TF1_AllChipFits = new_names->getTF1_AllChipFits();
  //string TF1_AllChannelFits = new_names->getTF1_AllChannelFits();


  
  if ( FitScanIsPersisted(scanNumber, runNumber, moduleName, variable) == 0 ) { 
      
      cout << "...creating new FitScanResult obj from persistency" << endl;
      //Add at the end of the Unique ID, after the ModuleName, the string "Persisted"
      //string pers_
      int dot = moduleName.find('.');
      string Pers_ModuleID = moduleName.substr(0, dot).c_str();  
      Pers_Modulename = Pers_ModuleID + ".Persisted";
      
  

    } else {

      cout << "WARNING: the FitScanResult has NOT been persisted!!" <<endl;
      //Add at the end of the Unique ID, after the ModuleName, the string "Persisted"
      int dot = moduleName.find('.');
      string Pers_ModuleID = moduleName.substr(0, dot).c_str();   
      Pers_Modulename = Pers_ModuleID + ".Unpersisted";
      FitScanResult* f = NULL;   //NB: it's different from the previous two functions
      return f;                  //!!!!!!ERROR is f is never defined before!!!!!!
                                 //!!!!Needs Debugging!!!!!
    }

  
  /* Variable initialisation */
 

  /* Opening File */
  TFile *inspect_file = new TFile(filename.c_str(),"read");
  if (inspect_file->IsZombie() == true) {
    cout << "Problem in opening the file"<<endl; 
 
  }
  
  
  gDirectory->cd(runID.c_str());
  gDirectory->cd(moduleID.c_str());
  gDirectory->cd(testType.c_str());
  gDirectory->cd(sVariable.c_str());
  gDirectory->cd(scanID.c_str());
  
  /*
  TObject* pers_Threshold = gDirectory->FindObjectAny(thresholdID.c_str()); 
  //Retrieve Threshold
  TVectorD* vpers_Threshold = dynamic_cast<TVectorD*>(pers_Threshold);
  double *temp_vpers_Threshold = vpers_Threshold->GetElements();
  m.threshold = temp_vpers_Threshold[0];
*/


 /* ?????????? Retrieve ScanPoints...!!!!I know it's a very bad coding!!!! ??????? TO BE CHECKED ???????*/
  TObject* pers_vscanpoints = gDirectory->FindObjectAny(vpointsID.c_str()); 
  TVector* vpers_vscanpoints = dynamic_cast<TVector*>(pers_vscanpoints); 
  //TVector* vpers_vscanpoints = NULL;
  //vpers_vscanpoints->Read(vpointsID.c_str());
  //float *temp_vpers_vscanpoints = vpers_vscanpoints->GetElements(); 
  float *temp_vpers_vscanpoints = NULL;
  temp_vpers_vscanpoints = vpers_vscanpoints->GetElements();


  TObject* pers_vNEvents = gDirectory->FindObjectAny(vNEventsID.c_str());
  TVector* vpers_vNEvents = dynamic_cast<TVector*>(pers_vNEvents); 
  

  int NoElements = vpers_vNEvents->GetNoElements();  
  

  //!!!!Truncate float into int
  unsigned int temp_vpers_vNEvents[NoElements];
  unsigned int truncated_vpers_vNEvents;
  for (int i=0; i<NoElements; ++i) {
    truncated_vpers_vNEvents = int(*vpers_vNEvents->GetElements());
    //cout<< " I am here" <<endl;
    temp_vpers_vNEvents[i] = truncated_vpers_vNEvents;
  }

 
  TObject* pers_vNErrorEvents = gDirectory->FindObjectAny(vNErrorEventsID.c_str());
  TVector* vpers_vNErrorEvents = dynamic_cast<TVector*>(pers_vNErrorEvents); 
  //!!!!Truncate float into int
  unsigned int temp_vpers_vNErrorEvents[NoElements];
  unsigned int truncated_vpers_vNErrorEvents;
  for (int i=0; i<NoElements; ++i) {
    truncated_vpers_vNErrorEvents = int(*vpers_vNErrorEvents->GetElements());
    temp_vpers_vNErrorEvents[i] = truncated_vpers_vNErrorEvents;
  }


  ScanPoints *pts = new ScanPoints( NoElements, temp_vpers_vscanpoints ,temp_vpers_vNEvents ,temp_vpers_vNErrorEvents );
  /*??????????????????????????????????????????????????????????????????????????*/

  

  gDirectory->cd(RODID.c_str());
  gDirectory->cd(FitID.c_str());

  
  //Creating FitScanResult object 
  ScanHeader s(scanNumber, runNumber, Pers_Modulename , variable);
  FitScanResult* f = new FitScanResult(s, m, *pts); 
  cout<< f->getHeader().getModuleName()<<endl;
  return f;
  




}




void ArchFitScanResult::SaveFitComment() {

  // Saving Txt Comments at the Fun level
  
  string filename = names->getfilename();
  string runID = names->getRunID();
  string moduleID = names->getModuleID();
  string testType = names->getTestType();
  string variable = names->getVariable();
  string scanID = names->getScanID();
  string RODID = names->getRODID();
  string FitID = names->getFitID();

  TFile *file = new TFile(filename.c_str(),"update");
  if (file->IsZombie() == true) {
    cout << "The ScanResult has NOT been saved in any file"<<endl; 
    return ;
  }
  /* Making RunNumber */
  TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str()); 
  if (!this_run) {
    //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
    this_run = file->mkdir(runID.c_str());
    //cout<<"New RunNumber Dir made "<<endl;
  }
  this_run->cd();  //make this_run the current directory

  /* Making moduleNumber   */
  
  TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
  if (!this_module) {
    //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
    this_module =gDirectory ->mkdir(moduleID.c_str());
  }
  this_module->cd();


  /* Making TestType   */
  TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
  if (!this_testType) {
    //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
    this_testType = gDirectory->mkdir(testType.c_str());
  }
  this_testType->cd();

  
  /* Making Varaible   */
  TDirectory* this_variable = (TDirectory*) gDirectory->Get(variable.c_str());
  if (!this_variable) {
    //cout<<"This NEW test "<< variable <<" doesn't exist"<<endl;
    this_variable = gDirectory->mkdir(variable.c_str());
  }
  this_variable->cd();

  /* Making scanNumber   */
  TDirectory* this_scan = (TDirectory*) gDirectory->Get(scanID.c_str());
  if (!this_scan) {
    //cout<<"This NEW scan "<< scanID <<" doesn't exist"<<endl;
    this_scan =gDirectory ->mkdir(scanID.c_str());
  }
  this_scan->cd();   

  /* Making ROD   */ 
  TDirectory* this_ROD = (TDirectory*) this_scan->Get(RODID.c_str());
  if (!this_ROD) {
    //cout<<"This NEW ROD  doesn't exist"<<endl;
    this_ROD = this_scan->mkdir(RODID.c_str());
  }
  this_ROD->cd();
 
  
  /* Making ROD Fit    */
    TDirectory* this_fit = (TDirectory*) this_ROD->Get(FitID.c_str()); 
    if (!this_fit) {
      //cout<<"This NEW Fit Data  doesn't exist"<<endl;
      this_fit = this_ROD->mkdir(FitID.c_str());
    }
    this_fit->cd();  



  //...Opening TxtComment file 
  ifstream in;
  in.open(names->getTxtCommentFitName().c_str());

  int commentN;
    int sz = 1000; // Buffer size;
    char buf[sz];
    
    
    int nlines = 0;
    while (1) {
      in >> commentN;
      in.get(buf, sz);
      if (!in.good()) break;
      //cout<< " CommentN = "<< commentN << " String = "<< buf <<endl;
      TObjString Comment(buf);
      TObject* pers_TxtCommentN = gDirectory->FindObjectAny(names->getFitTxtComment(commentN).c_str());
      if (!pers_TxtCommentN) {
	//cout<<" TxtComment Never Persisted...persisting" <<endl;
	Comment.Write(names->getFitTxtComment(commentN).c_str());
      }
      nlines++;   
    }
    //printf(" found %d points \n",nlines);
    
    
    in.close();
    file->Close();

}

