/*
 * MRSPanel.java
 *
 * Created on 25 April 2003, 15:21
 */

package TestGUI;

import javax.swing.*;
import Sct.IS.SctNames;
import mrs.*;

/**
 *
 * @author  palmer
 */
public class MRSPanel extends javax.swing.JPanel implements MessageListener {
    
    /** Creates new form MRSPanel */
    public MRSPanel(JTextArea taMessages) {
        this.taMessages = taMessages;
        initComponents();
        myInitComponents();
    }
    
    void close() {
        try {
            mrs.unsubscribe("ALL");
        } catch (RuntimeException re) {
            taMessages.append("MRSPanel: Error unsubscribing from MRS: " + re.getMessage() + "\n");
        }
    }
    
    private void myInitComponents() {
        taMRS = new JTextArea() {
            public void append(String str) {
                super.append(str);
                setCaretPosition(getText().length());
            }
        };
        taMRS.setEditable(false);
        jScrollPane1.setViewportView(taMRS);
        
        try {            
            mrs = new MRSReceiver(SctNames.getPartitionName());
            mrs.subscribe("ALL", this);
            lPartition.setText(lPartition.getText() + SctNames.getPartitionName());
        } catch (RuntimeException re) {
            taMessages.append("MRSPanel: Error initializing MRS: " + re.getMessage() + "  " + re + "\n");
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jScrollPane1 = new javax.swing.JScrollPane();
        lPartition = new javax.swing.JLabel();
        
        setLayout(new java.awt.BorderLayout());
        
        add(jScrollPane1, java.awt.BorderLayout.CENTER);
        
        lPartition.setText("MRS Messages for Partition ");
        add(lPartition, java.awt.BorderLayout.NORTH);
        
    }//GEN-END:initComponents

    public void messageReceived(mrs.MessageEvent messageEvent) {
        taMRS.append(messageEvent.getMessage() + "\n" + messageEvent.getMessageText() + "\n\n");
    }    
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lPartition;
    // End of variables declaration//GEN-END:variables
    private JTextArea taMessages;
    private JTextArea taMRS;
    private MRSReceiver mrs;
}
