/*
 * ExampleSequenceRequest.java
 *
 * Created on 14 August 2003, 10:45
 */

package TestGUI;
import Sct_CalibrationController.*;
import Sct_SctApi.*;
import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.PortableServer.*;
import org.omg.PortableServer.POA;
import org.omg.CosNaming.NamingContextPackage.*;
/**
 *
 * @author  palmer
 */
public class ExampleSequenceRequest extends SequenceRequestPOA {
    
    private SctApi api;
    private TestRequest responseCurve;
    
    public ExampleSequenceRequest(CalibrationController cc) {
        TestLibrary tl = cc.getTestLibrary();
        System.out.println(tl);
        responseCurve = tl.responseCurve();
    }
    
    public boolean applyConfigChanges(int index) {
        System.out.println("Apply config changes: " + index);
        return false;
    }    
    
    public void endSequence() {
        System.out.println("end sequence");
        api = null;        
    }
    
    public TestRequest getNextTest(int index) {
        System.out.println("getNextTest " + index);
        
        switch(index) {
            case 0:
                return responseCurve;
            default:
                return null;
        }
    }
    
    public String startSequence(SctApi api) {
        this.api = api;
        return "ExampleSequenceRequest";
    }
    
}
