/*
 * CalibrationControllerPanel.java
 *
 * Created on 30 July 2003, 23:01
 */

package TestGUI;

import javax.swing.*;
import Sct_CalibrationController.*;
import Sct.IS.SctNames;
import is.*;
import GuiComponents.System.*;

/**
 *
 * @author  Matthew Palmer
 */
public class CalibrationControllerPanel extends javax.swing.JPanel implements InfoListener {
    
    /** Creates new form CalibrationControllerPanel */
    public CalibrationControllerPanel(JTextArea taMessages) {
        this.taMessages = taMessages;
        si = SystemInterface.getInstance();
        initComponents();
        myInitComponents();
    }
    
    private void myInitComponents() {     
        //Get Status from IS if it is there
        try {
            CalibrationControllerStatus status = new CalibrationControllerStatus();
            SctNames.getISRepository().getValue(SctNames.getControlISServer() + ".Status", status);
            updateStatus(status);
        } catch (RuntimeException e) {
            taMessages.append("Couldn't get CalibrationController Status: " + e.getMessage() + "\n");
            updateStatus(null);
        }
        
        //Now subscribe to IS server
        try {
            SctNames.getISRepository().subscribe(SctNames.getControlISServer(), "Status", false, this);
        } catch (RuntimeException e) {
            taMessages.append("Couldn't subscribe to ControlData IS Server: " + e.getMessage() + "\n");
        }
    }
    
    /**
     * Call this to get rid of any connections etc
     */
    void close() {
        //Unsubscribe from IS
        try {
            SctNames.getISRepository().unsubscribe(SctNames.getControlISServer(), "Status", false);
        } catch (RuntimeException e) {
            taMessages.append("Couldn't unsubscribe from ControlData IS Server: " + e.getMessage() + "\n");
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;
        
        jPanel1 = new javax.swing.JPanel();
        bRefresh = new javax.swing.JButton();
        tStatus = new javax.swing.JTable();
        jLabel1 = new javax.swing.JLabel();
        bPing = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        bCharacter = new javax.swing.JButton();
        bResponse = new javax.swing.JButton();
        bThreshold = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        bStrobeDelay = new javax.swing.JButton();
        bNMask = new javax.swing.JButton();
        bThreePt = new javax.swing.JButton();
        
        setLayout(new java.awt.GridBagLayout());
        
        jPanel1.setLayout(new java.awt.GridBagLayout());
        
        jPanel1.setBorder(new javax.swing.border.TitledBorder("Calibration Controller"));
        bRefresh.setText("Refresh");
        bRefresh.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bRefreshActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel1.add(bRefresh, gridBagConstraints);
        
        tStatus.setBorder(new javax.swing.border.EtchedBorder());
        tStatus.setModel(new javax.swing.table.DefaultTableModel(
        new Object [][] {
            {"Status", "UNAVAILABLE"},
            {"Current Sequence", null},
            {"Current Test", null},
            {"Current Scan Index", null}
        },
        new String [] {
            "Name", "Value"
        }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                false, false
            };
            
            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
            
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        tStatus.setIntercellSpacing(new java.awt.Dimension(5, 5));
        tStatus.setMinimumSize(new java.awt.Dimension(200, 80));
        tStatus.setPreferredSize(new java.awt.Dimension(300, 80));
        tStatus.setRowHeight(20);
        tStatus.setShowHorizontalLines(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        jPanel1.add(tStatus, gridBagConstraints);
        
        jLabel1.setText("Status");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        jPanel1.add(jLabel1, gridBagConstraints);
        
        bPing.setText("Ping");
        bPing.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bPingActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel1.add(bPing, gridBagConstraints);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        add(jPanel1, gridBagConstraints);
        
        jPanel2.setBorder(new javax.swing.border.TitledBorder("Sequences, Tests and Scans"));
        bCharacter.setText("Characterization Sequence");
        bCharacter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bCharacterActionPerformed(evt);
            }
        });
        
        jPanel2.add(bCharacter);
        
        bResponse.setText("Response Curve");
        bResponse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bResponseActionPerformed(evt);
            }
        });
        
        jPanel2.add(bResponse);
        
        bThreshold.setText("ExampleTestRequest");
        bThreshold.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bThresholdActionPerformed(evt);
            }
        });
        
        jPanel2.add(bThreshold);
        
        jButton1.setText("ExampleSequenceRequest");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        
        jPanel2.add(jButton1);
        
        bStrobeDelay.setText("StrobeDelay");
        bStrobeDelay.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bStrobeDelayActionPerformed(evt);
            }
        });
        
        jPanel2.add(bStrobeDelay);
        
        bNMask.setText("NMask");
        bNMask.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bNMaskActionPerformed(evt);
            }
        });
        
        jPanel2.add(bNMask);
        
        bThreePt.setText("ThreePointGain");
        bThreePt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bThreePtActionPerformed(evt);
            }
        });
        
        jPanel2.add(bThreePt);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jPanel2, gridBagConstraints);
        
    }//GEN-END:initComponents

    private void bThreePtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bThreePtActionPerformed
        CalibrationController cc = si.getCalibrationController();
        if (cc == null) {
            taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        cc.doTest(cc.getTestLibrary().threePointGain());
    }//GEN-LAST:event_bThreePtActionPerformed

    private void bNMaskActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bNMaskActionPerformed
        CalibrationController cc = si.getCalibrationController();
        if (cc == null) {
            taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        cc.doTest(cc.getTestLibrary().nmask());
    }//GEN-LAST:event_bNMaskActionPerformed

    private void bStrobeDelayActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bStrobeDelayActionPerformed
        CalibrationController cc = si.getCalibrationController();
        if (cc == null) {
            taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        cc.doTest(cc.getTestLibrary().strobeDelay());
    }//GEN-LAST:event_bStrobeDelayActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        CalibrationController cc = si.getCalibrationController();
        if (cc == null) {
            taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        ExampleSequenceRequest r = new ExampleSequenceRequest(cc);
        SequenceRequest tr = r._this(ipc.Core.getORB());
        cc.doSequence(tr);
    }//GEN-LAST:event_jButton1ActionPerformed

    private void bThresholdActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bThresholdActionPerformed
        CalibrationController cc = si.getCalibrationController();
        if (cc == null) {
            taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        ExampleTestRequest r = new ExampleTestRequest();
        TestRequest tr = r._this(ipc.Core.getORB());
        cc.doTest(tr);        
    }//GEN-LAST:event_bThresholdActionPerformed

    private void bResponseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bResponseActionPerformed
        CalibrationController cc = si.getCalibrationController();
        if (cc == null) {
            taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        cc.doTest(cc.getTestLibrary().responseCurve());
    }//GEN-LAST:event_bResponseActionPerformed

    private void bCharacterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bCharacterActionPerformed
        CalibrationController cc = si.getCalibrationController();
        if (cc == null) {
            taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        cc.doSequence(cc.getSequenceLibrary().characterizationSequence());
    }//GEN-LAST:event_bCharacterActionPerformed

    private void bPingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bPingActionPerformed
        ipc.InfoHolder infoHolder = new ipc.InfoHolder();
        CalibrationController cc = si.getCalibrationController();
        if (cc != null)  {
            cc.get_info(infoHolder);
            ipc.Info info = infoHolder.value;
            taMessages.append("CalibrationController running: " + info.pid + " by " + info.owner + " on " +info.host + " since " + info.time + "\n");
        } else {
            taMessages.append("CalibrationController not running\n");
        }
    }//GEN-LAST:event_bPingActionPerformed

    private void bRefreshActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRefreshActionPerformed
        this.si.refresh();
	myInitComponents();
    }//GEN-LAST:event_bRefreshActionPerformed
    
    
    void updateStatus(CalibrationControllerStatus status) {
        if (status == null) {
            tStatus.getModel().setValueAt("UNAVAILABLE", 0, 1);
            tStatus.getModel().setValueAt("", 1, 1);
            tStatus.getModel().setValueAt("", 2, 1);
            tStatus.getModel().setValueAt("", 3, 1);
        } else {
            switch (status.status) {
                case CalibrationControllerStatus.LOADED:
                    tStatus.getModel().setValueAt("LOADED", 0, 1);
                    break;
                case CalibrationControllerStatus.INCONTROL:
                    tStatus.getModel().setValueAt("INCONTROL", 0, 1);
                    break;
                case CalibrationControllerStatus.BUSY:
                    tStatus.getModel().setValueAt("BUSY", 0, 1);
                    break;
                default:
                    tStatus.getModel().setValueAt("UNKNOWN", 0, 1);
            }
            tStatus.getModel().setValueAt(status.currentSequence, 1, 1);
            tStatus.getModel().setValueAt(status.currentTest, 2, 1);
            tStatus.getModel().setValueAt("" + status.currentScanIndex, 3, 1);
        }
    }
    
    public void infoCreated(is.InfoEvent infoEvent) {
        try {
            CalibrationControllerStatus status = new CalibrationControllerStatus();
            infoEvent.getValue(status);
            updateStatus(status);
        } catch (InfoNotCompatibleException e) {
            taMessages.append("Unable to read IS object - not a CalibrationControllerStatus: " + e.getMessage() + "\n");
        }
    }
    
    public void infoDeleted(is.InfoEvent infoEvent) {
        updateStatus(null);
    }
    
    //Pass to infoCreated
    public void infoUpdated(is.InfoEvent infoEvent) {
        infoCreated(infoEvent);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bCharacter;
    private javax.swing.JButton bNMask;
    private javax.swing.JButton bPing;
    private javax.swing.JButton bRefresh;
    private javax.swing.JButton bResponse;
    private javax.swing.JButton bStrobeDelay;
    private javax.swing.JButton bThreePt;
    private javax.swing.JButton bThreshold;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTable tStatus;
    // End of variables declaration//GEN-END:variables
    private JTextArea taMessages;
    private SystemInterface si;
}
