#ifndef SCTDATA_SUMMARYWRITER_H
#define SCTDATA_SUMMARYWRITER_H

#include <boost/utility.hpp>
#include <string>
#include <iostream>
#include "Sct/IoExceptions.h"
#include "Sct/LogicErrors.h"

/**
   Classes which convert SctData::TestResult data into SctDaq style summary files, which 
   can be uploaded to the SCT production database.
   @author Alan Barr
   @date 16 september 2003
*/
namespace SctData {
    class TestResult;
    class DefectList;

    namespace TestSummary{
	/** 
	    A SummaryWriter is a type of output streamer for a TestResult 
	    Concrete SummaryWriters should add themselves to the SummaryManager's
	    map, and impliment the write() method.
	*/

	class SummaryWriter : boost::noncopyable {
	public:
	    /** 
		append a test to the appropriate SctDaq-style file 
		@param t the TestResult to write the summary for.
		@param out the output stream to write to.
	    */
	    virtual void write(const TestResult& t, std::ostream& out) const throw(Sct::IoError, Sct::LogicError)=0;

	    /**
	       Writes a ModuleDefectList to the output stream 
	       @param list the moduledefect list to write
	       @param out the ostream to write it to.
	     */
	    void write(const DefectList& list, std::ostream& out ) const throw(Sct::IoError, Sct::LogicError);

	    /** do NOT delete the singleton ! */
	    virtual ~SummaryWriter();
	    /** 
		print a header for the current module 
		@param t the TestResult for which the header should be written.
		@param os the output stream to print it to.
	    */
	    void writeHeader(const TestResult&, std::ostream& os) const throw();
	protected:
	    SummaryWriter(); /// used only by sub-classes to add themselves to the map.
	    /**
	       convenience method returns the name of chip, e.g. M0 or S3
	    */
	    static string getChipName(const short unsigned ichip) throw();
	};
    }
} // end of namespace SctDaqSummary

#endif // #ifdef SCTDATA_SUMMARYWRITER_H
