// For gcc296 floor
#include <cmath>

#include "SummaryManager.h"
#include "RxDelaySummaryWriter.h"
#include "SctData/RxDelayTestResult.h"

namespace SctData {
    namespace TestSummary{
	using namespace std;

	void RxDelaySummaryWriter::write(const TestResult& t, ostream& out) const throw(Sct::IoError, Sct::LogicError)
	{
	    const RxDelayTestResult& result  = dynamic_cast<const RxDelayTestResult&>(t);

	    out << "#\n%RxDelay\n#\n#Delays\n";
	    for (unsigned ilink=0; ilink<nLinkModule; ++ilink){
	      out << static_cast<int>(floor( result.getOptimum(ilink) + 0.5)) << " ";
	    }
	     out << "\n#" << endl;
	    SummaryWriter::write(result.getDefects(), out);
	}

	bool RxDelaySummaryWriter::inMap = SummaryManager::instance().addWriter("SctData::RxDelayTestResult", shared_ptr<SummaryWriter>(new RxDelaySummaryWriter()));
    }
}
