#include "Observer.hh"
#include "ipc/object.h"
#include "Sct/Exception.h"
#include <iostream>
#include <memory>

using namespace std;
using namespace Sct;

int main(int argc, char**argv){
    setExceptionHandlers(argv[0]);
    
    ObserverStatus status;    
    auto_ptr<IPCPartition> p (new IPCPartition("SCT") );
    
    cout <<" ... getting a handle ..."<<endl;
    IPCObjectVar<Observer_T_ObserverInterface> handle = 
	p->lookup("TestListenerServer","TestListener",Observer_T_ObserverInterface::ILUClassRecord);
    
    if (handle==0){ cerr<<"Error: handle==0"<<endl; return -1;}
    
    status.returnCode=0;

    if (argc==1){
	int i=1;
	
	while (i>0) {
	    cout << "enter data (integers) terminated by 0, or -1 to stop"<<endl;
	    cin >> i;
	    handle->ipcAdd(&status, i);
	    cout << "busy=" << handle->ipcBusy(&status) <<endl;
	}
	if (i==-1) handle->ipcStop(&status);
    }	
    cout << "nWorkers = " << handle->ipcNWorkers(&status) <<endl;
    cout << "busy     = " << handle->ipcBusy(&status) <<endl;
    cout << "Queue    = " << handle->ipcQueueSize(&status) <<endl;
}
