#include "NoiseOccupancyDisplayer.h"
#include "DisplayManager.h"
#include "DisplayInfo.h"

#include "SctData/NoiseOccupancyTestResult.h"
#include "SctData/DefectList.h"

#include "TF1.h"
#include "TGraph.h"
#include "TCanvas.h"

#include <iostream>
#include <string>
#include <boost/shared_ptr.hpp>

using namespace std;
using namespace SctData;
using namespace Sct;
using namespace boost;

namespace SctDataDisplay {


class NoiseOccupancyDisplayData : public DisplayData {
public:
    vector<shared_ptr<TCanvas> > canvas;
    shared_ptr<const NoiseOccupancyTestResult> test;
};        
    
bool NoiseOccupancyDisplayer::inMap = DisplayManager::addToMap("SctData::NoiseOccupancyTestResult", shared_ptr<Displayer>(new NoiseOccupancyDisplayer()));
    
    
shared_ptr<DisplayData> NoiseOccupancyDisplayer::display(shared_ptr<const Sct::Serializable> serial, const DisplayInfo& info, std::ostream& os) { 
    shared_ptr<NoiseOccupancyDisplayData> data (new NoiseOccupancyDisplayData());    
    data->test = dynamic_pointer_cast<const NoiseOccupancyTestResult>(serial);
    
    //Now print out defects:
    os << endl << "Defects: " << endl;
    printDefectList(data->test->getDefects(), os);
    os << endl;

    if (info.displayChips.size() > 0) displayChips(*data, info, os);
    
    return data;
}

void NoiseOccupancyDisplayer::displayChips(NoiseOccupancyDisplayData& data, const DisplayInfo& info, std::ostream& os) {
    shared_ptr<TCanvas> c = createCanvas(data.test->getModuleName() + "_NO", "Noise Occupancy plots for " + data.test->getModuleName());
    data.canvas.push_back(c);
    divideCanvas(info.displayChips.size(), *c);
    
    for (unsigned int i=0; i<info.displayChips.size(); ++i) {
        const ChipNOResult& r = data.test->getChipResult(info.displayChips[i]);
	os << "Chip " << i << " noise: " << r.getNoise() << "  Fit params: ";
	for (int j=0; j<r.fit->GetNpar(); ++j) os << r.fit->GetParameter(j) << "   ";
	os << endl;
        c->cd(i+1);
	if (r.graph.get()){
	  if (r.graph->GetN()!=0){
	    r.graph->Draw("ap");
	    if (r.graph->GetHistogram()){
	      r.graph->GetHistogram()->SetXTitle("Q^2");
	      r.graph->GetHistogram()->SetYTitle("Log Occ");
	    }
	  }
	}
	if (r.fit.get()) {
	  r.fit->SetLineWidth(1);
	  r.fit->SetLineColor(2);
	  r.fit->SetFillStyle(0);
	  r.fit->Draw("lsame");
	}	
    }

}
}
