#ifndef SCTDATADISPLAY_FITDISPLAYER_H
#define SCTDATADISPLAY_FITDISPLAYER_H

#include "Displayer.h"
#include <memory>

class TH1;

namespace SctData {
    class FitObject;
    class FitScanResult;
}

using std::auto_ptr;    


namespace SctDataDisplay {

    class FitDisplayData;
    
/**
  Displays FitScanResults
  @author Matthew Palmer
  */
class FitDisplayer : public Displayer {
public:
    shared_ptr<DisplayData> display(shared_ptr<const Sct::Serializable> data, const DisplayInfo& info, std::ostream& os);
    
private:
    static bool inMap;
    
    /**
      Displays chip fits
      */
    void displayChips(const SctData::FitScanResult& data, const DisplayInfo& info, FitDisplayData& data, std::ostream& os);
    
    /**
      Displays channel fits
      */
    void displayChannels(const SctData::FitScanResult& data, const DisplayInfo& info, FitDisplayData& data, std::ostream& os);
    
    /**
      Display a single fit
      */
    void displayFit(SctData::FitObject& fo, auto_ptr<TH1> h, FitDisplayData& data, std::ostream& os);
};
}

#endif //SCTDATADISPLAY_FITDISPLAYER_H
