void DspDump () {
  gSystem->Load("libTApi.so");

  if(!tapi) 
    tapi = new TApi();

  tapi->initialiseAll(1);

  // get DSP number (-1 for MDSP) starting address and number of bytes to read

  char response;
  do {
    int dspNumber, dspStart, dspEnd;

    cout << "DSP number (-1 for Master):";
    cin >> dspNumber;
    hex(cin);
    cout << "Starting address (hex): ";
    cin >> dspStart;
    cout << "Ending address (hex): ";
    cin >> dspEnd;
    dec(cin);
    if(dspEnd < dspStart) {
      cout << "Start must be less than end, skipping\n";
    } else {
      int numWords = (dspEnd +1 - dspStart)/4;

      tapi->DspBlockRead(0, 0, 0, dspStart, numWords, dspNumber);
    }    

    // do another?
    cout << "Do another? [Y/n]: ";
    cin >> response;
  } while (response != 'n');

  // Clean up before exiting
  delete tapi;

  return ; 
}


