#include "Sct/SctNames.h"
#include "extraScans.h"
#include "autoConfig.h"
#include "SctApiImpl.h"

using namespace std;
using namespace SctApi;

using namespace SctApi::AutoConf;

#include "ABCD/ABCDscans.h"

void AutoConfigurer::run() {
  api.modifyBOCParam(ST_RX_THRESHOLD, 128);

  // Setup a raw TX scan...
  boost::shared_ptr<Scan> txScan(new ScanDefImpl);

  txScan->setNTrigs(1);
  txScan->getTrigger1()->singleL1A();

  txScan->configure(SCT_SCAN_RAW_TX_CHANNELS, 0, 47, 1);    // SCT_SCAN_RAW_TX_CHANNELS

  // Run on each ROD in turn
  const list<RodLabel> rodList = api.listRods();
  for(list<RodLabel>::const_iterator rl = rodList.begin();
      rl!=rodList.end();
      rl++){

    const RodLabel &label = *rl;

    MRSStream &mrs = Sct::SctNames::Mrs();

    std::vector< std::vector <char> > probeResult = api.probeScan(label.partition, label.crate, label.rod, txScan);

    if(probeResult.size() < 48) {
      cout << "Result too small: " << probeResult.size() << endl;
      return;
    }

    for(int point=0; point<48; point++) {
      if(probeResult[point].size() < 96) {
        cout << "Scan too small: " << probeResult[point].size() << endl;
        return;
      }
      for(int ch=0; ch<48; ch++) {
        char link0 = probeResult[point][ch*2 + 0];
        char link1 = probeResult[point][ch*2 + 1];
        if((link0 == '2' || link0 == 'E') 
           && (link1 == '2' || link1 == 'E')) {
          cout << "Module " << ch << " connected to tx " << point << endl;

          results.push_back(AutoResult(label.partition, label.crate, label.rod, point, ch));

          mrs << "MODULE_FOUND" << MRS_INFORMATION << MRS_QUALIF("SCTAPI") << MRS_QUALIF("AUTOPROBE") 
            // << MRS_PARAM<int>("select", configuration.select)
              << MRS_PARAM<int>("pTTC", point)
            // << MRS_PARAM<int>("rTTC", configuration.rTTC)
              << MRS_PARAM<int>("rx0", ch*2 + 0)
              << MRS_PARAM<int>("rx1", ch*2 + 1)
              << MRS_PARAM<int>("crate", label.crate)
              << MRS_PARAM<int>("rod", label.rod)
              << MRS_PARAM<int>("harness", ch / 6)
              << MRS_PARAM<int>("position", (ch % 6) + 1)
              << MRS_TEXT("Module response found")
              << ENDM;

          break;
        } else {
          continue;
        }
      }
    }
    // Restore previous configuration
    api.configureBOC(label.partition, label.crate, label.rod);
  }
}

list<AutoResult> AutoConfigurer::getResults() {
  return results;
}
