#include <utility>

#include "SctApi.h"
#include "SctApiHisto.h"
#include "SctApiRodInfo.h"

using namespace std;

namespace SctApi {

RodScanEx &ScanEx::getOrNewRod(const RodLabel &l, RodScanEx defaultEx) {
  RodInfoMap::iterator result = rodInfo.find(l);
  if(result == rodInfo.end()) {
    rodInfo.insert(std::make_pair(l, defaultEx));
    result = rodInfo.find(l);
  }
  return result->second;
}

const RodScanEx &ScanEx::getRodScanInfo(const RodLabel &l) const {
  RodInfoMap::const_iterator result = rodInfo.find(l);
  if(result == rodInfo.end()) {
    cerr << " getRodScanInfo const: ROD not found\n";
    throw SctApiException("Bad ROD");
  }
  return result->second;
}

RodScanEx &ScanEx::getRodScanInfo(const RodLabel &l) {
  RodInfoMap::iterator result = rodInfo.find(l);
  if(result == rodInfo.end()) {
    cerr << " getRodScanInfo: ROD not found\n";
    throw SctApiException("Bad ROD");
  }
  return result->second;
}

std::list<RodLabel> SctApi::listRods() {
  return rodList;
}

void SctApi::addRodToList(RodLabel newRod) {
  rodList.push_back(newRod);
  RodInfo newInfo;
  rodInfoList.insert(make_pair(newRod, newInfo));
}

RodInfo &SctApi::getRodInfo(const RodLabel &l){
  std::map<RodLabel, RodInfo>::iterator result = rodInfoList.find(l);
  if(result == rodInfoList.end()) {
    cerr << " getRodInfo: ROD not found\n";
    throw SctApiException("Bad ROD");
  }
  return result->second;
}
}
