#ifndef SCTTEST_MODULEDATAFILE_H
#define SCTTEST_MODULEDATAFILE_H

#include <string>
#include <fstream>

using std::string;
using std::ifstream;

namespace SctTest {

struct ModuleDataRecord {
    string serialNumber;
    string testName;
    string dataPath;
    unsigned int runNumber;
    unsigned int scanNumber;
};

/**
  The file represents the file that says for each module where the data files are.
  @author Matthew Palmer
  */
class ModuleDataFile {
public:
    ModuleDataFile(string fileName);
    bool hasMoreRecords();
    ModuleDataRecord getNextRecord();

private:
    ifstream file;
};
}

#endif //SCTTEST_MODULEDATAFILE_H
