#!/usr/bin/perl
#
# This script generates configuration files
# It uses a template, a list of available data files

#Settings and args
my $outputDir = "";
my $dataFile = "$ENV{'SCT_DAQ_ROOT'}/installed/config/TestConfig/XmlSummary.txt";
my $outputFile = "./TestRod.xml";
my $templateFile = "$ENV{'SCT_DAQ_ROOT'}/installed/config/TestConfig/templateRod.xml";
my $nGenModules = 0;
my $nUseModules = -1;

#Available files
my @xmlFiles;
my @serialNums;

#Output:
my $crate;
my $geography;
my $includes;

sub main() {
    handleArgs();
    parseFile();
    initStrings();
    addAllModules();
    completeStrings();
}

sub handleArgs() {
    if (@ARGV < 1) {printHelp();}
    while (@ARGV) {
        for (shift @ARGV) {
            /-d/ && do {
                if (@ARGV == 0) {printHelp();}
                $dataFile = shift @ARGV;
                last;
            };
            /-n/ && do {
                if (@ARGV == 0) {printHelp();}
                $nUseModules = shift @ARGV;
                last;
            };
            /-o/ && do {
                if (@ARGV == 0) {printHelp();}
                $outputDir = shift(@ARGV) . "/";
                last;
            };
            /-t/ && do {
                if (@ARGV == 0) {printHelp();}
                $templateFile = shift @ARGV;
                last;
            };
            if ($nGenModules == 0) {$nGenModules = $_;}
            else {printHelp();}
        }
    }
    if ($nGenModules == 0) {printHelp();}
}

sub parseFile() {
    open FILE, "<", $dataFile or die "Can't open file $dataFile\n";
    while (<FILE>) {
        if (/^(\d+)\s+(\S+)/) {
            push @serialNums, $1;
            push @xmlFiles, substituteEnv($2);
        }
    }
    close FILE;

    if ($nUseModules < 0 || $nUseModules > @serialNums) {$nUseModules = @serialNums;}
    print "$dataFile parsed.  Found ".scalar(@serialNums)." module XML files\n";
}

sub substituteEnv() {
    my ($file) = @_;
    while ($file =~ /\$\{(\w+?)\}/) {
        $var = $1;
        $subst = $ENV{$var};
        $file =~ s/\$\{$var\}/$subst/g;
    }    
    return $file;
}

sub addAllModules() {
    my $loop = 0;
    my $index = 0;

    for ($done=0; $done < $nGenModules; ++$done, ++$index) {
        if ($index == @serialNums) {
            ++$loop;
            $index = 0;
        }
        my $s = $serialNums[$index];
        $s += $loop * 1000000000000;
        my $xmlFile = copyFile($s, $serialNums[$index], $xmlFiles[$index]);
        addModule($s, $xmlFile);
    }
}

sub copyFile() {
    my ($serial, $origSerial, $inputFile) = @_;
    my $data;

    open FILE, "<", $inputFile or die "Can't open xml file: $inputFile\n";
    while (<FILE>) {
        s/$origSerial/$serial/g;
        $data .= $_;
    }
    close FILE;

    my $fileName = $outputDir."module$serial.xml";
    open FILE, ">", $fileName or die "Couldn't open output xml file: $fileName\n";
    print FILE $data;
    close FILE;

    return $fileName;
}


my $rod = 0;
my $mur = 0;
my $module = 0;
my $row = 0;

sub addModule() {
    my ($serial, $file) = @_;

    if ($module == 6) {
        $module = 0;
        ++$mur;
        endMur();
        if ($mur == 8) {
           $mur = 0;
            ++$rod;
            endRod();
            createNewRod();
        }
        createNewMur();
    }

    my $id = $module + 1;
    $crate .= "        <module id=\"$id\">$serial</module>
        <rmodule id=\"$id\">$serial</rmodule>\n";

    $modules .= "    <xi:include href=\"$file\"/>\n";

    ++$module;
}

sub createNewMur() {
    my $id = $rod * 8 + $mur;
    $crate .= "      <MUR order=\"$mur\" id=\"$id\" xmlns:xi=\"http://www.w3.org/2001/XInclude\">\n";

    my $position = $id %2;
    if ($position == 0) {
        if ($id != 0) {endRow();}
        createNewRow();
    }
    if ($position == 0) {$position = "-1";}

    $geography .= "    <MUR id=\"$id\" position=\"$position\" />\n";
}

sub createNewRow() {
    $geography .= "    <row id=\"$row\">\n";
    ++$row;
}

sub endRow() {
    $geography .= "    </row>\n";
}

sub endMur() {
    $crate .= "      </MUR>\n";
}

sub endRod() {
    $crate .= "    </rod>\n";
}

sub createNewRod() {
    $crate .= "  <rod xmlns:xi=\"http://www.w3.org/2001/XInclude\" id=\"$rod\">
    <baseAddress>0x0f000000</baseAddress>
    <mapSize>0xc00040</mapSize>
    <numSlaves>4</numSlaves>
    <slave id=\"0\">
      <emifFile>slvEmif_sdram.bin</emifFile>
      <ipramFile>slaveRun_IPRAM.bin</ipramFile>
      <idramFile>slaveRun_IDRAM.bin</idramFile>
      <extFile>slaveRun_xcode.bin</extFile>
    </slave>
    <slave id=\"1\">
      <emifFile>slvEmif_sdram.bin</emifFile>
      <ipramFile>slaveRun_IPRAM.bin</ipramFile>
      <idramFile>slaveRun_IDRAM.bin</idramFile>
      <extFile>slaveRun_xcode.bin</extFile>
    </slave>
    <slave id=\"2\">
      <emifFile>slvEmif_sdram.bin</emifFile>
      <ipramFile>slaveRun_IPRAM.bin</ipramFile>
      <idramFile>slaveRun_IDRAM.bin</idramFile>
      <extFile>slaveRun_xcode.bin</extFile>
    </slave>
    <slave id=\"3\">
      <emifFile>slvEmif_sdram.bin</emifFile>
      <ipramFile>slaveRun_IPRAM.bin</ipramFile>
      <idramFile>slaveRun_IDRAM.bin</idramFile>
      <extFile>slaveRun_xcode.bin</extFile>
    </slave>
";
}

sub completeStrings() {
    endMur();
    endRod();
    endRow();
    $geography .= "    </barrel>
  </geography>\n";
    $modules .= "  </modules>\n";
    $crate .= "  </crate>
 </partition>\n";
    my $output = $crate.$geography.$modules."</configuration>\n\n";

    open FILE, ">", $outputFile or die "Couldn't open $outputFile for output\n";
    print FILE $output;
    close FILE;
}

sub initStrings() {
    open FILE, "<", $templateFile or die "Can't open template file: $templateFile\n";
    while (<FILE>) {
        $crate .= $_;
    }
    close FILE;
    $geography .= "  <geography>
    <barrel id=\"3\">\n";
    $modules .= "  <modules>\n";

    createNewRod();
    createNewMur();
}


sub printHelp() {
        print "GenerateConfiguration.pl [-d <DataFile>] [-n <n>] [-o <dir>] [-t <template>] <# modules>
GenerateConfiguration generates a configuration file for testing purposes.
There is one required argument: the number of modules to generate

Options:
    -d <DataFile> Use the given data file (defaults to $dataFile)
    -n <n>        Only use the first n data files
    -o <dir>      Directory to output to (defaults to .)
    -t <template> Use the given template file (defaults to $templateFile)
";
        exit(0);
}


main();
0;
