#include "TGraphAsymmErrorsFix.h"

using namespace std;

void TGraphAsymmErrorsFix::Set(Int_t n) throw() {
	if (n < 0) n = 0;
	if (n == fNpoints) return;
		
	TGraph::Set(n);
	
	Double_t *exh=0, *exl=0, *eyh=0, *eyl=0;
	if (n > 0) {
		exh = new Double_t[n];
		exl = new Double_t[n];
		eyh = new Double_t[n];
		eyl = new Double_t[n];
	}
	Int_t i;
	for (i=0; i<fNpoints && i<n;i++) {
		if (fEXlow) exl[i] = fEXlow[i];
		if (fEXhigh) exh[i] = fEXhigh[i];
		if (fEYlow) eyl[i] = fEYlow[i];
		if (fEYhigh) eyh [i] = fEYhigh[i];
	}
	for (i=fNpoints; i<n;i++) {
		exh[i] = 0;
		exl[i] = 0;
		eyh[i] = 0;
		eyl[i] = 0;
	}
	delete [] fEXlow;
	delete [] fEXhigh;
	delete [] fEYlow;
	delete [] fEYhigh;
	
	fEXhigh = exh;
	fEXlow = exl;
	fEYhigh = eyh;
	fEYlow = eyl;
}
