#include "RawScanResultIOHelper.h"
#include "TH2.h"
#include "RawScanResult.h"

namespace SctData {

RawScanResultIOHelper::RawScanResultIOHelper() throw() {}

RawScanResult& RawScanResultIOHelper::create() throw() {
    raw = new RawScanResult();
    return *raw;
}

void RawScanResultIOHelper::set
    (const RawScanResult& ob) throw() {
    ///@todo Const cast for no great reason - this all needs to be looked at some more
    raw = const_cast<RawScanResult*>(&ob);
}

TH2D* RawScanResultIOHelper::getScanData(int iLink) const throw() {
    if (iLink == 0)
        return raw->scanData_link0.get();
    else
        return raw->scanData_link1.get();
}

void RawScanResultIOHelper::setDataType(UINT16 type) const throw(){
  raw->m_dataType=type;
}

void RawScanResultIOHelper::setScanData(int iLink, auto_ptr<TH2D> data) const throw() {
    if (iLink == 0)
        raw->scanData_link0 = data;
    else
        raw->scanData_link1 = data; 
}

}
