#ifndef OCCUPANCY_PROJECTOR_H
#define OCCUPANCY_PROJECTOR_H
#include "Sct/Exception.h"
#include "RawScanResult.h"
#include "ModuleElement.h"

class TH1;
namespace SctData{
    using Sct::LogicError;

    class ModuleConfiguration;
    class DefectList;
    /**
     * Altorithms for projecting TH1 occupancy histograms out of a RawScanResult.
     * Allow skipping of masked/defective channels.
     */

    class OccupancyProjector{
    public:
	/// Make a default projector (no vetos) with a reference to a particular RawScanResult;
	OccupancyProjector(const RawScanResult& r) throw();
	/// destructor
	~OccupancyProjector() throw() ;
	/// getOccupancy
	/**
	 * Utility function that gets a general occupancy hist.
	 * @return a pointer to the new TH1D containing the occupancy.
	 * @param the name of the histogram
	 * @param the ModuleElement for which the occupancy is required.
	 */
	auto_ptr<TH1> getOccupancy(const char* name, const ModuleElement& element) const throw(LogicError);
	/// veto masked channels. @param ModuleConfiguration containing the mask.
	void vetoMaskedChannels(const ModuleConfiguration&) throw();
	/// veto all defective channels. @param ModuleDefectList
	void vetoAllDefects(const DefectList&) throw();
	/// veto all "seriously defective" channels. @param ModuleDefectList
	void vetoSeriousDefects(const DefectList&) throw();
	/// switch off all vetos
	void unsetVetos() throw();
    private:
	//void setRawScanResult(const RawScanResult&) throw();
	OccupancyProjector() throw() ; //< don't do this: require a rawScanResult
	bool m_vetoAllDefects;
	const RawScanResult* raw;
	const ModuleConfiguration* config;
	const DefectList* defects;
    };
} // end of namespace SctData
#endif //#ifndef OCCUPANCY_PROJECTOR_H
