#ifndef NULLVARIABLE_H
#define NULLVARIABLE_H

#include "ConfigurationVariable.h"

namespace SctData {
    
 
/**
  A null ConfigurationVariable - used when eg a Test has only 1 scan in it.
  All methods return 0.
  */
class NullVariable : public ConfigurationVariable {
public:
    static const NullVariable& instance() throw();
    
    //Conversions
    virtual double getLinkActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int link) const throw();    
    virtual double getChipActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int chip) const throw();
    virtual double getChannelActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int channel) const throw();    
    
    virtual double getLinkLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int link) const throw();
    virtual double getChipLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int chip) const throw();    
    virtual double getChannelLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int channel) const throw();    
    
    virtual double getChipActualPoint(const ModuleConfiguration& config, unsigned int chip) const throw();
    virtual void setChipActualPoint(double actualPt, ModuleConfiguration& config, unsigned int chip) const throw();

    
private:
    NullVariable();
    static const NullVariable& nv;	//static var used to force creation at static initialization time
};

    
}

#endif //#ifndef NULLVARIABLE_H
