#include "NullVariable.h"
#include "ModuleConfiguration.h"


namespace SctData {
    
NullVariable::NullVariable() : ConfigurationVariable(0, "Null Variable", "Represents no variable") {}
const NullVariable::NullVariable& nv = NullVariable::instance();
    
const NullVariable& NullVariable::instance() throw() {
    static NullVariable* var = new NullVariable();
    return *var;
}
    
double NullVariable::getLinkActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int link) const throw() {
    return 0;
}

double NullVariable::getChipActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int chip) const throw() {
    return 0;
}

double NullVariable::getChannelActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int channel) const throw() {
    return 0;
}
    
double NullVariable::getLinkLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int link) const throw() {
    return 0;
}
double NullVariable::getChipLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int chip) const throw() {
    return 0;
}

double NullVariable::getChannelLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int channel) const throw() {
    return 0;
}
    
double NullVariable::getChipActualPoint(const ModuleConfiguration& config, unsigned int chip) const throw() {
    return 0;
}

void NullVariable::setChipActualPoint(double actualPt, ModuleConfiguration& config, unsigned int chip) const throw() {}

}
