#include "../TrimRangeTestResult.h"
#include "TrimRangeTestResult_ChipTrimDataStreamer_v1.h"

using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned TrimRangeTestResult_ChipTrimDataStreamer_v1::s_version=1;

TrimRangeTestResult_ChipTrimDataStreamer_v1::TrimRangeTestResult_ChipTrimDataStreamer_v1() throw() {}

bool TrimRangeTestResult_ChipTrimDataStreamer_v1::inMap = IOManager::addToMap("SctData::TrimRangeTestResult::ChipTrimData",  auto_ptr<Streamer>(new TrimRangeTestResult_ChipTrimDataStreamer_v1()));


shared_ptr<Streamable> TrimRangeTestResult_ChipTrimDataStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> ad (new TrimRangeTestResult::ChipTrimData());
    read(in, *ad, manager);
    return ad;
}

void TrimRangeTestResult_ChipTrimDataStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    const TrimRangeTestResult::ChipTrimData& chiptrim = dynamic_cast <const TrimRangeTestResult::ChipTrimData&>(ob);
    out << (int) chiptrim.channelData.size();
    for (unsigned i=0; i<chiptrim.channelData.size(); ++i){
	Stat<TrimRangeTestResult::TrimData> d=chiptrim.channelData.getAt(i);
	
	out << d.valid << d.value.p0 << d.value.p1;
	out << (int) d.value.graph.size();
	for (unsigned ipt=0; ipt<d.value.graph.size(); ++ipt){
	    out << d.value.graph[ipt].first << d.value.graph[ipt].second;
	}
    }

}

void TrimRangeTestResult_ChipTrimDataStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    TrimRangeTestResult::ChipTrimData& chiptrim = dynamic_cast <TrimRangeTestResult::ChipTrimData&>(ob);

    int size; in >> size; 
    chiptrim.channelData.resize(nChannelChip);
    for (unsigned i=0; i<nChannelChip; ++i){
	Stat<TrimRangeTestResult::TrimData>& d=chiptrim.channelData.modifyAt(i);
	in >> d.valid >> d.value.p0 >> d.value.p1;
	
	in >> size; d.value.graph.resize(size);
	for (int ipt=0; ipt<size; ++ipt){
	    float first, second;
	    in >> first; in >> second;
	    d.value.graph[ipt]=pair<float,float>(first,second);
	}
    }
}

}
} 

