#ifndef SCTDATA_IO_TGRAPHSTREAMER_H
#define SCTDATA_IO_TGRAPHSTREAMER_H

#include "Sct/Streamer.h"
#include "TGraph.h"
#include "Sct/Exception.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

using namespace Sct;

namespace SctData {
namespace IO {

/**
 * Allows serialization of root TGraph object to IS.
 */
class TGraphStreamer_v1 : public virtual Streamer {
public:

    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);   
virtual unsigned getVersion() const throw() {return s_version;}

protected:
    /**
     	Protected constructor
     	*/
    TGraphStreamer_v1() throw();

private:
 static unsigned s_version;
    static bool inMap;		//true if successfully added to IOManager map
};

}
}
#endif // #ifndef SCTDATA_IO_TGRAPHSTREAMER_H
