#ifndef SCTDATA_IO_RXTHRESHOLDTESTRESULTSTREAMER_H
#define SCTDATA_IO_RXTHRESHOLDTESTRESULTSTREAMER_H

#include "TestResultStreamer_v1.h"

namespace SctData {
namespace IO {

/**
 * This class allows publishing and refreshing of RxThresholdTestResult objects to and from IS.
 * The published and refreshed elements are:
 * -> The fraction (usually 0.25) of the distance from the leading edge to the 
 * falling edge with which the optima were found.
 * -> the (usually 12 - 1 per chip) opimum values found by the analysis.
 */
class RxThresholdTestResultStreamer_v1 : public Sct::Streamer {
public:
    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);   
     virtual unsigned getVersion() const throw() {return s_version;}
     
private:
    RxThresholdTestResultStreamer_v1() throw();		///< Constructor is private
   static unsigned s_version;
   static bool inMap;					///< The static dummy variable for the IOManager map
};
}
}
#endif // #ifndef SCTDATA_IO_RXTHRESHOLDTESTRESULTSTREAMER_H
