#ifndef SCTDATA_IO_RESULTHEADERSTREAMER_H
#define SCTDATA_IO_RESULTHEADERSTREAMER_H

#include "Sct/Streamer.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

using namespace Sct;

/**
 * The namespace containing the objects needed to publish 
 * and refresh the data objects to and from IS.
 */

namespace SctData {
namespace IO {

/**
This class is an ISSerializer for reading/writing ResultHeaders to/from IS.
Note that this class handles the reading and writing of ScanTypes itself
*/
class ResultHeaderStreamer_v1 : public virtual Streamer {
public:
    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);   
    virtual unsigned getVersion() const throw() {return s_version;}
private:
    ResultHeaderStreamer_v1() throw();			///< Constructor is private
    static unsigned s_version;
    static bool inMap;					///< The static dummy variable for the IOManager map
};
}
}
#endif //#ifndef SCTDATA_IO_RESULTHEADERSTREAMER_H
