#include "ResponseCurveStreamer_v1.h"
#include "../ResponseCurve.h"

using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned ResponseCurveStreamer_v1::s_version=1;
	
ResponseCurveStreamer_v1::ResponseCurveStreamer_v1() throw() {}

bool ResponseCurveStreamer_v1::inMap = IOManager::addToMap("SctData::ResponseCurve",  auto_ptr<Streamer>(new ResponseCurveStreamer_v1()));

void ResponseCurveStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    const ResponseCurve& rc = dynamic_cast<const ResponseCurve&>(ob);
    out << ResponseCurveMap::getMap().getIndex(rc.getCurveName());
    for (int ipar=0; ipar<3; ++ipar) {
        out << rc.getFunction()->GetParameter(ipar);
    }
}

shared_ptr<Streamable> ResponseCurveStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    int index;
    in >> index;
    auto_ptr<ResponseCurve> rc=ResponseCurveMap::getMap().get(index);
    for (int ipar=0; ipar<3; ++ipar) {
        double value;
        in >> value;
        rc->getFunction()->SetParameter(ipar,value);
    }
    return shared_ptr<Streamable>(rc);
}

void ResponseCurveStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    dynamic_cast<ResponseCurve&>(ob);
    ob = *read(in, manager);
}
}
}

