#include "ModuleConfigurationStreamer_v1.h"
#include "../ModuleConfiguration.h"
#include <CommonWithDsp/sctStructure.h>

namespace SctData {
namespace IO {

unsigned ModuleConfigurationStreamer_v1::s_version=1;
/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */

ModuleConfigurationStreamer_v1::ModuleConfigurationStreamer_v1() throw() {}
	
bool ModuleConfigurationStreamer_v1::inMap = IOManager::addToMap("SctData::ModuleConfiguration",  std::auto_ptr<Streamer>(new ModuleConfigurationStreamer_v1()));


shared_ptr<Streamable> ModuleConfigurationStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> m (new ModuleConfiguration());
    read(in, *m, manager);
    return m;
}

void ModuleConfigurationStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    const ModuleConfiguration& config = dynamic_cast<const ModuleConfiguration&>(ob);
    const ABCDModule& data = config.getABCDModule();
    
    for (unsigned int i=0; i<Sct::nChipModule; ++i) {
	writeChipConfig(out, data.chip[i]);
    }
    out << data.present << data.active << data.select << data.groupId << data.pTTC << data.rTTC;
    out.put(data.rx, 2);  
    //cout << (int) data.rx[3] << endl;
}

void ModuleConfigurationStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    ModuleConfiguration& config = dynamic_cast<ModuleConfiguration&>(ob);
    ABCDModule& data = config.getABCDModule();
    
    for (unsigned int i=0; i<Sct::nChipModule; ++i) {
	readChipConfig(in, data.chip[i]);
    }
    in >> data.present >> data.active >> data.select >> data.groupId >> data.pTTC >> data.rTTC;
    in.get(data.rx, 2);
    //cout << "data.groupId: " << (int)data.groupId  << endl;
    //cout << (int)data.rx[3] << endl;
}

void ModuleConfigurationStreamer_v1::writeChipConfig(OStream& out, const ABCDChip& data) const throw(Sct::LogicError, Sct::IoError){
    out << data.active << data.address << data.target;
      
    //ABCDBasic stuff:
    
    //Config values
    out << (UINT16)data.basic.config.readoutMode << (UINT16)data.basic.config.calibMode << (UINT16)data.basic.config.trimRange;
    out << (UINT16)data.basic.config.edgeDetect << (UINT16)data.basic.config.mask << (UINT16)data.basic.config.accumulate;
    out << (UINT16)data.basic.config.inputBypass << (UINT16)data.basic.config.outputBypass << (UINT16)data.basic.config.master;
    out << (UINT16)data.basic.config.end << (UINT16)data.basic.config.feedThrough;
    
    out << data.basic.vthr << data.basic.vcal << data.basic.delay << data.basic.preamp << data.basic.shaper;
    out.put(data.basic.mask, 4);
    
    //ABCDCalData
    out << data.caldata.rc_function;
    out.put(data.caldata.rc_params, 3);
    out << data.caldata.c_factor;
    
    out.put(data.trim, Sct::nChannelChip);
}

void ModuleConfigurationStreamer_v1::readChipConfig(IStream& in, ABCDChip& data) const throw(Sct::LogicError, Sct::IoError) {
    in >> data.active >> data.address >> data.target;
    
    //ABCDBasic stuff:
    
    //Config values    
    UINT16 temp = 0;
    in >> temp;
    data.basic.config.readoutMode = temp;
    in >> temp;
    data.basic.config.calibMode = temp;
    in >> temp;
    data.basic.config.trimRange = temp;
    in >> temp;
    data.basic.config.edgeDetect = temp;
    in >> temp;
    data.basic.config.mask = temp;
    in >> temp;
    data.basic.config.accumulate = temp;
    in >> temp;
    data.basic.config.inputBypass = temp;
    in >> temp;
    data.basic.config.outputBypass = temp;
    in >> temp;
    data.basic.config.master = temp;
    in >> temp;
    data.basic.config.end = temp;
    in >> temp;
    data.basic.config.feedThrough = temp;
    
    in >> data.basic.vthr >> data.basic.vcal >> data.basic.delay >> data.basic.preamp >> data.basic.shaper;
    in.get(data.basic.mask, 4);
    
    //ABCDCalData
    in >> data.caldata.rc_function;
    //cout << "rc_function: " << (int)data.caldata.rc_function << endl;
    in.get(data.caldata.rc_params, 3);
    in >> data.caldata.c_factor;
    
    in.get(data.trim, Sct::nChannelChip);
    //cout << "data.trim[35]" << (int)data.trim[35] << endl;    
}
}
}
