#ifndef SCTDATA_IO_FULLBYPASSTESTRESULTSTREAMER_H
#define SCTDATA_IO_FULLBYPASSTESTRESULTSTREAMER_H

#include "TestResultStreamer_v1.h"
#include "../FullBypassTestResult.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

namespace SctData {
namespace IO {

/**
 * This class allows publishing and refreshing of FullBypassTestResult objects
 */
class FullBypassTestResultStreamer_v1 : public Sct::Streamer {
public:
    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);   
    void writeChipResult(OStream& out, const FullBypassTestResult::ChipFBResult&, const IOManager& manager) const throw(LogicError, IoError) ;
    void readChipResult(IStream& in, FullBypassTestResult::ChipFBResult&, const IOManager& manager) const throw(LogicError, IoError) ;
virtual unsigned getVersion() const throw() {return s_version;}

private:
    FullBypassTestResultStreamer_v1() throw();
    static unsigned s_version;
    static bool inMap;
};
}
}

#endif // #ifndef SCTDATA_IO_FULLBYPASSTESTRESULTSTREAMER_H
