#ifndef SCTDATA_IO_DCSDATASTREAMER_v1_H
#define SCTDATA_IO_DCSDATASTREAMER_v1_H

#include "Sct/Streamer.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

class Sct::OStream;
class Sct::IStream;
class Sct::IOManager;

namespace SctData {
namespace IO{
/**
  This class represents the configuration of a chip.
  It is based on the data stored in ABCDChip
  @author Matthew Palmer
  @date 28 May 2003
  */
class DcsDataStreamer_v1 : public Sct::Streamer {
 public:
  virtual void write(Sct::OStream& out, const Sct::Streamable& ob, const Sct::IOManager& manager) const throw(Sct::LogicError, Sct::IoError);
    virtual shared_ptr<Sct::Streamable> read(Sct::IStream& in, const Sct::IOManager& manager) const throw(Sct::LogicError, Sct::IoError);
    virtual void read(Sct::IStream& in, Sct::Streamable& ob, const Sct::IOManager& manager) const throw(Sct::LogicError, Sct::IoError);
    virtual unsigned getVersion() const throw() {return s_version;}
 private:
    DcsDataStreamer_v1() throw();
    static unsigned s_version;
    static bool inMap;
};

}//namespace IO
}//namespace SctData
#endif //#ifndef SCTDATA_IO_DCSDATASTREAMER_v1_H
