#ifndef DEFAULTVARIABLE_H
#define DEFAULTVARIABLE_H

#include "ConfigurationVariable.h"

namespace SctData {
    
/**
  This class represents a configuration variable for which there is no specific class.
  The actual<->logical mapping is therefore actual=logical.
  It can also be used as an implementation class for variables that have that same mapping.
  @todo Think: Is this necessary?  Does it imply public virtual inheritance of
  ConfigurationVariable ...are there any problems?
  */
class DefaultVariable : public ConfigurationVariable {
public:
    /**
      Get the ConfigurationVariable that corresponds to the given typeRep
      May not be a ConfigurationVariable
      @todo Should we issue a warning in this case?
      */
    static shared_ptr<ConfigurationVariable> instance(unsigned int typeRep);
    
    //Conversions
    virtual double getLinkActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int link) const throw();    
    virtual double getChipActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int chip) const throw();
    virtual double getChannelActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int channel) const throw();    
    
    virtual double getLinkLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int link) const throw();
    virtual double getChipLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int chip) const throw();    
    virtual double getChannelLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int channel) const throw();    
    
    //ModuleConfiguration interaction
    /**
      Obviously, these can't work for a DefaultVariable.
      */
    virtual double getChipActualPoint(const ModuleConfiguration& config, unsigned int chip) const throw();
    virtual void setChipActualPoint(double actualPt, ModuleConfiguration& config, unsigned int chip) const throw();

    
protected:
    //DefaultVariable(unsigned int typeVal, string variableName, string strategyDescription);
private:
    /**
      Only the ConfigurationVariable is allowed to create these as they must be created
      on the heap
      */
    DefaultVariable(unsigned int typeRep);
    friend class ConfigurationVariableIOHelper;
};
}

#endif //#ifndef DEFAULTVARIABLE_H
