#ifndef SCTDATA_DCS_DATA_H
#define SCTDATA_DCS_DATA_H

#include "Sct/Streamable.h"
#include <boost/shared_ptr.hpp>
#include <string>

namespace SctData{
  /** 
      Class intended to hold the DCS data coming from a module,
      so that it can be archived along with test results etc. 
      for easy cross-referencing.
  */
class DcsData : public Sct::Streamable{
 public:
  /* default ctr */
  DcsData();
  /** Streamable over-ride */
  virtual std::string getClassName() const;
  /** detr*/
  virtual ~DcsData();
  
  /** HV bias Voltage */
  float getVbias() const;    
  /** HV bias current */
  float getIbias() const;
  /** Temperature sensor 0 */
  float getT0() const;
  /** Temperature sensor 1 */
  float getT1() const;
  /** Analogue LV voltage */
  float getVcc() const;
  /** Analogue LV current */
  float getIcc() const;
  /** Digital LV voltage */
  float getVdd() const;
  /** Digital LV current */
  float getIdd() const;

  void setVbias(float val);   
  void setIbias(float val);
  void setT0(float val);
  void setT1(float val);
  void setVcc(float val);
  void setIcc(float val);
  void setVdd(float val);
  void setIdd(float val);

 private:
  float m_vBias, m_iBias, m_t0, m_t1, m_vcc, m_icc, m_vdd, m_idd;
};

}

#endif //#ifndef SCTDATA_DCS_DATA_H
