#include "ConfigurationVariable.h"
#include "DefaultVariable.h"
#include "Sct/SctParameters.h"

namespace SctData {

ConfigurationVariable::ConfigurationVariable(unsigned int typeVal, string variableName, string strategyDescription) : typeVal(typeVal), variableName(variableName), strategyDescription(strategyDescription) {
    getMap()[typeVal] = shared_ptr<ConfigurationVariable>(this);
}

map<unsigned short, shared_ptr<ConfigurationVariable> >& ConfigurationVariable::getMap() throw() {
    static VariableTypeMap* map = new VariableTypeMap();
    return *map;
}

bool ConfigurationVariable::operator== (const ConfigurationVariable& var) const throw() {
    return typeVal == var.typeVal;
}

bool ConfigurationVariable::operator!= (const ConfigurationVariable& var) const throw() {
    return typeVal != var.typeVal;
}

string ConfigurationVariable::getClassName() const throw() {
    return "SctData::ConfigurationVariable";
}
	
string ConfigurationVariable::getVariableName() const throw() {
    return variableName;
}

string ConfigurationVariable::getStrategyDescription() const throw() {
    return strategyDescription;
}

double ConfigurationVariable::getChipLogicalPoint(const ModuleConfiguration& config, unsigned int chip) const throw() {
    return getChipLogicalPoint(getChipActualPoint(config, chip), config, chip);
}

void ConfigurationVariable::setChipLogicalPoint(double logicalPt, ModuleConfiguration& config, unsigned int chip) const throw() {
    setChipActualPoint(getChipActualPoint(logicalPt, config, chip), config, chip);
}

double ConfigurationVariable::getModuleLogicalPoint(const ModuleConfiguration& config) const throw() {
    return getChipLogicalPoint(config, 0);
}

void ConfigurationVariable::setModuleLogicalPoint(double logicalPt, ModuleConfiguration& config) const throw() {
    for (unsigned int i=0; i<Sct::nChipModule; ++i) {
	setChipLogicalPoint(logicalPt, config, i);
    }
}

unsigned short ConfigurationVariableIOHelper::getTypeRep(const ConfigurationVariable& var) throw(){
    return var.typeVal;
}

shared_ptr<ConfigurationVariable> ConfigurationVariableIOHelper::getFromTypeRep(unsigned short typeRep) throw() {
    if (ConfigurationVariable::getMap().count(typeRep) == 0) {
	//Create a DefaultVariable instead (will be automagically added to the map)
	new DefaultVariable(typeRep);
    }
    return ConfigurationVariable::getMap()[typeRep];
}
    
}
