package SctData;

import Sct.*;

/**
 * This class represents all possible things what might come out of IS.
 * @author Matthew Palmer
 */
public abstract class ScanResult implements Serializable {
    /** Creates a ScanResult by referencing the header, module configuration and points*/
    public ScanResult(ResultHeader header, ModuleConfiguration moduleConfig, ScanPoints points) {
        this.header = header;
        this.moduleConfig = moduleConfig;
        this.points = points;
    }

    /** Copy constructor 
        @todo Implement this if we need it.  (Or use clone interface
     */
    public ScanResult(ScanResult scan) {
        
    }

    public ResultHeader getHeader() {
        return header;
    }

    public ModuleConfiguration getConfiguration() {
        return moduleConfig;
    }

    public ScanPoints getPoints() {
        return points;
    }
    
    protected void _read(IStream s, ObjectManager o) throws java.io.IOException {
        header = (ResultHeader)o.readObject(s, "Header", "SctData.ResultHeader");
        points = (ScanPoints)o.readObject(s, "ScanPoints", "SctData.ScanPoints");
        moduleConfig = (ModuleConfiguration)o.readObject(s, "Configuration", "SctData.ModuleConfiguration");
    }
    
    public void write(OStream s, ObjectManager o) throws java.io.IOException {
        o.writeObject(s, "Header", header, false);
        o.writeObject(s, "ScanPoints", points, false);
        o.writeObject(s, "Configuration", moduleConfig, false);    
    }
    
    /** For I/O use only */
    protected ScanResult(IStream s, ObjectManager o) throws java.io.IOException {
        _read(s, o);
    }

    protected ResultHeader header;
    protected ModuleConfiguration moduleConfig;
    protected ScanPoints points;
}
