#include "UniqueID_Test.h"
#include "Sct/LogicErrors.h"
#include "../src/UniqueID.h"
#include <boost/test/unit_test.hpp>

using boost::unit_test_framework::test_suite;
using namespace Sct;

namespace SctData{

void testParse(){
    UniqueID n("123.56.234320443");
    BOOST_CHECK_EQUAL(123, n.getRunNumber());
    BOOST_CHECK_EQUAL(56, n.getScanNumber());
    BOOST_CHECK_EQUAL("234320443", n.getModule());
}

void testParseFail(){
    BOOST_CHECK_THROW(UniqueID n("123.56234320443"), Sct::InvalidArgumentError);
}


void testConstruct() {
    UniqueID n(123, 56, "234320443");
    BOOST_CHECK_EQUAL("123.56.234320443", n.getUniqueID());
}

void testCast() {
    UniqueID n(123, 56, "234320443");
    BOOST_CHECK_EQUAL((string)n, n.getUniqueID());
}

UniqueID_Test::UniqueID_Test() {
    add(BOOST_TEST_CASE(&testParse));
    add(BOOST_TEST_CASE(&testParseFail));
    add(BOOST_TEST_CASE(&testConstruct));
    add(BOOST_TEST_CASE(&testCast));
}
}
