#include <boost/test/unit_test.hpp>
#include "Streamer_Test.h"
#include "UniqueID_Test.h"
#include "Defect_Test.h"
#include "ResultHeader_Test.h"
#include "ObjectPool_Test.h"
#include "ModuleElement_Test.h"

using boost::unit_test_framework::test_suite;
using namespace SctData;

test_suite* init_unit_test_suite(int argc, char * argv[]) {
    std::auto_ptr<test_suite> test(BOOST_TEST_SUITE("Test package SctData"));

    test->add(new UniqueID_Test());
    test->add(new ModuleElement_Test());        
    test->add(new Defect_Test());
    test->add(new ResultHeader_Test());
    test->add(new ObjectPool_Test());
    test->add(new Streamer_Test());
    
    return test.release();
}
