#ifndef SCT_VERSIONNOTSUPPORTEDEXCEPTION_H
#define SCT_VERSIONNOTSUPPORTEDEXCEPTION_H

#include "IoExceptions.h"

namespace Sct {

/**
  Indicates an that an I/O operation failed because the version of the data was 
  not compatible with what the software was capable of dealing with.
  @author Matthew Palmer
  @ingroup Exceptions
  */
class VersionNotSupportedException : public IoException {
public:
    /**
      Creates an Exception with message msg and no cause
      */
    VersionNotSupportedException(const string& msg, const string& file, int line) throw() {
	initialize("BAD_VERSION", "Sct::VersionNotSupportedException", msg, 0, file, line);
    }
    
    /**
      Creates an Exception with a cause.  Useful for simply wrapping
      exceptions.
      */
    VersionNotSupportedException(Throwable& cause, const string& file, int line) throw() {
	initialize("BAD_VERSION", "Sct::VersionNotSupportedException", "", &cause, file, line);
    }
    
    /**
      Creates an Exception with a message and a cause
      */
    VersionNotSupportedException(const string& msg, Throwable& cause, const string& file, int line) throw() {
	initialize("BAD_VERSION", "Sct::VersionNotSupportedException", msg, &cause, file, line);
    }
    
protected:
    VersionNotSupportedException() throw() {}        
    
};    
}

#endif //SCT_VERSIONNOTSUPPORTEDEXCEPTION_H
