#ifndef SCT_ISOSTREAMWRAPPER_H
#define SCT_ISOSTREAMWRAPPER_H
#include "is/isstream.h"

namespace Sct{
   /** Wrapper to wrap a ISostream as a Sct::Ostream */
  class ISOStreamWrapper : public virtual ISostream {
  public:
    /** constructor takes ref to ISostream to be wrapped */
    ISOStreamWrapper(OStream& os) : os(os) {}
    virtual ~ISOStreamWrapper() {}

    virtual ISostream & operator<<(const char *str) {
        os << str;
        return *this;
    }

    virtual ISostream & operator<<(const unsigned char *str) {
        os << str;
	return *this;
    }

    virtual ISostream & operator<<(bool val) {
        os << val;
        return *this;
    }

    virtual ISostream & operator<<(char val) {
        os << val;
        return *this;
    }

    virtual ISostream & operator<<(unsigned char val) {
        os << val;
        return *this;
    }

    virtual ISostream & operator<<(short val) {
        os << val;
        return *this;
    }

    virtual ISostream & operator<<(unsigned short val) {
        os << val;
        return *this;
    }

    virtual ISostream & operator<<(int val) {
        os << val;
        return *this;
    }

    virtual ISostream & operator<<(unsigned int val) {
        os << val;
        return *this;
    }

    virtual ISostream & operator<<(long val)  {
        os << val;
        return *this;
    }

    virtual ISostream & operator<<(unsigned long val) {
        os << val;
        return *this;
    }

    virtual ISostream & operator<<(float val) {
        os << val;
        return *this;
    }

    virtual ISostream & operator<<(double val) {
        os << val;
        return *this;
    }

    virtual ISostream & operator<<(const std::string& val) {
        os << val;
        return *this;
    }

    virtual ISostream & operator<<(const OWLDate& val) {
      return *this;
    }
    virtual ISostream & operator<<(const OWLTime& val) {
      return *this;
    }

    virtual ISostream & put ( const bool * p, size_t size ) {
      os.put(p,size);
      return *this;
    }

    virtual ISostream & put ( const char * p, size_t size ) {
      os.put(p,size);
      return *this;
    }

    virtual ISostream & put ( const unsigned char * p, size_t size ) {
      os.put(p,size);
      return *this;
    }

    virtual ISostream & put( const short * p, size_t size ) {
	os.put(p,size);
	return *this;
    }

    virtual ISostream & put( const unsigned short * p, size_t size ) {
	os.put(p,size);
        return *this;
    }

    virtual ISostream & put( const int * p, size_t size ) {
	os.put(p,size);
        return *this;
    }

    virtual ISostream & put( const unsigned int * p, size_t size ) {
      os.put(p,size);
      return *this;
    }

    virtual ISostream & put( const long * p, size_t size ) {
      os.put(p,size);
      return *this;
    }

    virtual ISostream & put( const unsigned long * p, size_t size ) {
      os.put(p,size);
      return *this;
    }

    virtual ISostream & put( const float * p, size_t size ) {
	os.put(p,size);
        return *this;
    }

    virtual ISostream & put( const double * p, size_t size ) {
      os.put(p,size);
      return *this;
    }

    virtual ISostream & put( const std::string * p, size_t size ) {
	os.put(p,size);
        return *this;
    }

    virtual ISostream& put( const OWLDate * , size_t ){
      return *this;
    }
    
    virtual ISostream& put( const OWLTime * , size_t ){
      return *this;
    }

  private:
    ISOStreamWrapper();
    OStream& os;
  };
}

#endif // #ifndef SCT_ISOSTREAMWRAPPER_H
