#ifndef SCT_IS_ISTREAMIS_H
#define SCT_IS_ISTREAMIS_H

#include <is/isinfo.h>
#include "../IStream.h"

namespace Sct {
namespace IS {
  /** A IStream class for reading from the Information Service */    
class IStreamIS : public virtual IStream {
public:
    IStreamIS(ISistream& in) : in(in) {}
    
    virtual IStream & operator>>(char *str) {
	in >> str;
	return *this;
    }
    
    virtual IStream & operator>>(unsigned char *str) {
	in >> str;
	return *this;
    }
    
    virtual IStream & operator>>(char **str) {
	in >> str;
	return *this;
    }
    
    virtual IStream & operator>>(unsigned char **str) {
	in >> str;
	return *this;
    }
    
    virtual IStream & operator>>(bool& val) {
	in >> val;
	return *this;
    }
    
    virtual IStream & operator>>(char& val) {
	in >> val;
	return *this;
    }
    
    virtual IStream & operator>>(unsigned char& val) {
	in >> val;
	return *this;
    }
    
    virtual IStream & operator>>(short& val){
	in >> val;
	return *this;
    }
    
    virtual IStream & operator>>(unsigned short& val) {
	in >> val;
	return *this;
    }
    
    virtual IStream & operator>>(int& val) {
	in >> val;
	return *this;
    }
    
    virtual IStream & operator>>(unsigned int& val) {
	in >> val;
	return *this;
    }
    
    virtual IStream & operator>>(long& val) {
	in >> val;
	return *this;
    }
    
    virtual IStream & operator>>(unsigned long& val) {
	in >> val;
	return *this;
    }
    
    virtual IStream & operator>>(float& val) {
	in >> val;
	return *this;
    }
    
    virtual IStream & operator>>(double& val) {
	in >> val;
	return *this;
    }
    
    virtual IStream & operator>>(std::string& val) {
	in >> val;
	return *this;
    }
    
    virtual IStream & operator>>(OWLDate& val) {
	in >> val;
	return *this;
    }
    
    virtual IStream & operator>>(OWLTime& val) {
	in >> val;
	return *this;
    }
    
    
    virtual IStream & get( bool ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( char ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( unsigned char ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( short ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( unsigned short ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( int ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( unsigned int ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( long ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( unsigned long ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( float ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( double ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( std::string ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( OWLDate ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( OWLTime ** p, size_t & size ) {
	in.get(p, size);
	return *this;
    }
    
    
    virtual IStream & get( bool * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( char * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( unsigned char * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( short * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( unsigned short * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( int * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( unsigned int * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( long * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( unsigned long * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( float * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( double * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( std::string * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( OWLDate * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    virtual IStream & get( OWLTime * const p, const size_t size ) {
	in.get(p, size);
	return *this;
    }
    
    
private:
    ISistream& in;
};
    
}
}
#endif //SCT_IS_ISTREAMIS_H
