#include "IOManagerDummy.h"
#include "LogicErrors.h"
#include "Streamable.h"
#include "Streamer.h"
#include "XmlStyleStream.h"
#include <sstream>

namespace Sct {
  IOManagerDummy::IOManagerDummy() throw(){}

  IOManagerDummy& IOManagerDummy::instance() throw(){
    static IOManagerDummy man;
    return man;
  }
  void IOManagerDummy::write(const Serializable& ob, const IOParams* params) const {
    throw IllegalStateError("Should not be used!",__FILE__,__LINE__);
  }
  
  shared_ptr<Serializable> IOManagerDummy::read(const string& name, const IOParams* params) const {
    throw IllegalStateError("Should not be used!",__FILE__,__LINE__);
  }
  
  
  std::string IOManagerDummy::testStreaming1(const Streamable& ob) const {
     Streamer& streamer = getStreamer(ob.getClassName());
    std::ostringstream ostr; 
    XmlStyleOStream ad1(ostr);
    streamer.write(ad1, ob, *this);
    return ostr.str();
  }

  std::string IOManagerDummy::testStreaming2(const Streamable& ob) const {
    Streamer& streamer = getStreamer(ob.getClassName());
    std::ostringstream ostr; 
    XmlStyleOStream ad1(ostr);
    streamer.write(ad1, ob, *this);
    
    std::istringstream istr(ostr.str());
    XmlStyleIStream ad2(istr);
    shared_ptr<Streamable> testob = streamer.read(ad2, *this);

    std::ostringstream ostr2;
    XmlStyleOStream ad3(ostr2);
    streamer.write(ad3, *testob, *this);

    return ostr2.str();
  }
  
}
