#ifndef SCT_ARCHIVEFILE_IOMANAGERARCHIVEFILE_H
#define SCT_ARCHIVEFILE_IOMANAGERARCHIVEFILE_H

#include "IOManagerArchive.h"
#include "../IoExceptions.h"
#include "../LogicErrors.h"
#include <iostream>

namespace Sct{
namespace Archive {
  /**
     This IOManager writes to a gzipped ascii file. 
     It is expected to be used in archival, and so also makes use of streamer 
     versioning by inheriting from IOManagerStreamerVersioned. 
     The gzip compression level can be adjusted with setCompressionLevel().
     @note files are written to SCT_PERSISTENT_DIR.
   */
class IOManagerArchiveFile : public IOManagerArchive {
public:
  /** retrieve access to singleton */
  static IOManagerArchiveFile& instance();
  /** write using default streamers */
  virtual void write(const Serializable& ob, const IOParams* params = 0) const;
  /** read using appropriate streamers */
  virtual shared_ptr<Serializable> read(const string& name, const IOParams* params = 0) const;
  /** get some status information */
  virtual std::string status() const;
 private:
  IOManagerArchiveFile() throw();
  static IOManagerArchiveFile* s_man; ///< pointer to singleton
};
}
}
#endif //SCT_ARCHIVEFILE_IOMANAGERARCHIVEFILE_H
