/*
 * SCTNames.java
 *
 * Created on 17 December 2002, 21:54
 */

/**
 * This package holds things that are of interest to all of SCT.
 */
package Sct.IS;

import is.*;
import ipc.*;
import Sct.*;
import Sct.SearchClassLoader;
import java.util.HashMap;

/**
 * Declares useful functions for getting the name of the partition and so on.
 * They are static functions for future compatability concerns.
 * @author  Matthew Palmer
 * @date 17 December 2002
 */
public class SctNames {
    
    private static HashMap map = new HashMap();
    
    /** Can't be created*/
    private SctNames() {
    }
    
    private static Partition partition = null;
	private static Repository repository = null;
	
    /**
     * Looks to see if className is in the map.
     * Uses the SearchClassLoader to get the Class for className, then checks all 
     * base classes to see if they are in the map.
     * Returns a default ISServer otherwise....
     */
    public static String getISServer(String className) {                
        try {
            Class[] argTypes = {IStream.class, ObjectManager.class};
            Class c = SearchClassLoader.instance().loadClass(className, argTypes);
            String ISServer = (String)map.get(c);
            while (c!=null && ISServer == null) {
                c = c.getSuperclass();
                ISServer = (String)map.get(c);
            }             
            if (ISServer != null) return ISServer;
            else return getDefaultISServer();
            
        } catch (ClassNotFoundException e) {
            return getDefaultISServer();
        }              
    }
    
    public static void addToMap(Class classID, String ISServer) {
        map.put(classID,  ISServer);
    }
        
	public static String getPartitionName() {return "SCT";}
    
    public static String getDefaultISServer() {return "Default";}
	public static String getEventISServer() {return "EventData";}
    public static String getFitISServer() {return "FittedData";}
    public static String getTestISServer() {return "TestData";}
    public static String getControlISServer() {return "ControlData";}
	
    public static Partition getPartition() {
		if (partition == null) partition = new Partition(getPartitionName());
		return partition;
	}
	public static Repository getISRepository() {
		if (repository == null) repository = new SctRepository(getPartition());
		return repository;
	}

}
