/*
 * AbstractObjectManager.java
 *
 * Created on 16 September 2003, 11:23
 */

package Sct;
import java.io.*;
import java.lang.reflect.*;

/**
 * Provides a simple implementation of some of the methods and notable adds simple construction 
 * using reflection.  Implementors should feel free to override any/all (tho if all why use this!?) 
 * the methods.
 * @author Matthew Palmer
 */
public abstract class AbstractObjectManager implements ObjectManager {
    
    /**
     * A simple implementation that calss readClassName to get
     * the className from the IStream then forwards to readObject(IStream s, String name, String className);
     */
    public Streamable readObject(IStream s, String name)  throws IOException{
        String className = readClassName(s);
        return readObject(s, name, className);
    }
    
    /**
     * Uses createObject to create a Streamable and read it in from the Stream.
     */
    public Streamable readObject(IStream s, String name, String className) throws IOException{
        Streamable ob = createObject(s, className);        
        return ob;
    }
    
    /**
     * A simple implementation - if writeClassName, calls writeClassName to write the className
     * then class object.write(OStream s, this).
     */
    public void writeObject(OStream s, String name, Streamable object, boolean writeClassName) throws IOException{
        if (writeClassName) writeClassName(s,  object.getClassName());
        object.write(s, this);
    }
    
    
    /**
     * Creates the object with the className as given.
     * Uses the classLoader used to load this class.
     */
    protected Streamable createObject(IStream s, String className) throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        try {                                    
            Class c = cl.loadClass(className);
                                       
            try {
                Class[] argTypes = {IStream.class, ObjectManager.class};
                Object[] args = {s, this};
                Method m = c.getMethod("read", argTypes);
                if (!m.isAccessible()) {
                    try {
                        m.setAccessible(true);
                    } catch (SecurityException se) {
                        InvalidClassException ie = new InvalidClassException(className, "No accessible static method for class: " + className);
                        ie.initCause(se);
                        throw ie;
                    }
                }
                return (Streamable)m.invoke(null, args);
            
            } catch (NoSuchMethodException e) {
                InvalidClassException ie = new InvalidClassException(className, "No appropriate constructor or static method for class: " + className);
                ie.initCause(e);
                throw ie;
            } 
            catch (IllegalAccessException e) {
                InvalidClassException ie = new InvalidClassException(className, "No appropriate static method for class: " + className);
                ie.initCause(e);
                throw ie;
            }
            catch (IllegalArgumentException e) {
                throw new Error("Internal bug creating object", e);                
            }            
            catch (NullPointerException e) {
                InvalidClassException ie = new InvalidClassException(className, "Method is not static for class: " + className);
                ie.initCause(e);
                throw ie;                
            }            
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IOException) throw (IOException)e.getCause();
                if (e.getCause() instanceof RuntimeException) throw (RuntimeException)e.getCause();                
                throw new Error("Bug creating: " + className + " - threw unexpected exception", e.getCause());            
            }                       
            
        } catch (ClassNotFoundException cnfe) { 
            InvalidClassException ie = new InvalidClassException(className, "Couldn't find class: " + className);
            ie.initCause(cnfe);
            throw ie;
        }
    }
    
    /**
     * A simple method to read the className from the Stream
     * This should be overridden if necessary by the implementation.
     * It provides simple checking that ClassName returned is indeed a className and
     * not something else!
     */
    protected String readClassName(IStream in) throws IOException {
        String className = in.readString("ClassName");
	if (className.startsWith("SctClassName:")) {
            return Name.convertFromC(className.substring(13));
        } else {
            throw new InvalidClassException(className, "Stream does not contain a className");
        }
    }
    
    /**
     * Writes a className.
     * Goes together with readClassName and should be overriden if necessary.
     */
    protected void writeClassName(OStream out, String className) throws IOException {
        out.writeString("ClassName", "SctClassName:"+ Name.convertToC(className));
    }
   
    
}
