/*
 * TestStreamData.java
 *
 * Created on 16 September 2003, 10:06
 */

package Sct.TestFramework;

import java.util.*;
import java.io.IOException;

/**
 * This class holds the data from a TestOStream and can be read back into a TestIStream
 * It basically acts as a stack.
 * @author  palmer
 */
public class TestStreamData {
    
    private LinkedList list = new LinkedList();
    
    /** Creates a new instance of TestStreamData */
    public TestStreamData() {
    }
    
    public void add(String name, Object data) {
        DataItem i = new DataItem();
        i.name = name;
        i.data = data;
        list.add(i);
    }
    
    public Object get(String name) throws IOException {
        try {
            DataItem i = (DataItem)list.removeFirst();
            if (i.name.equals(name)) return i.data;
            else {
                IOException ioe = new IOException("Tried to read wrong data item.\nRequested: " + name + " Have: " + i.name);
                throw ioe;
            }
        } catch (NoSuchElementException e) {
            IOException ioe = new IOException("Tried to read too many items.");
            ioe.initCause(e);
            throw ioe;
        }
    }
    
    
    private class DataItem {
        String name;
        Object data;
    }
}
