// File: RodStatus.h

#ifndef SCTPIXELROD_RODSTATUS_H
#define SCTPIXELROD_RODSTATUS_H

#include "RodModule.h"

namespace SctPixelRod {

/*! 
 * @class RodStatus  
 *
 * @brief This is a class for ROD status reports.
 *
 * This class contains the status information for a ROD. For now it does very
 * little.
 *
 * @author Tom Meyer (meyer@iastate.edu) - originator
 */

class RodStatus
{
public:
	RodStatus();                                     // Constructor
	RodStatus( const RodStatus& );                   // Copy constructor
	~RodStatus();                                    // Destructor
	RodStatus& operator=( const RodStatus&);         //Overload = operator
        friend ostream& operator<<(ostream& os, RodModule& rod); //Overload << operator

	//! Accessor function to get slot number
	long getSlotNumber() const { return m_slotNumber; };

	//! Accessor function to get serial number
	long getSerialNumber() const { return m_serialNumber; };
	
	//! Accessor function to get number of slaves installed
	long getNumSlaves() const { return m_numSlaves; };
	
	//! Accessor function to get a status register.
	unsigned long getStatusReg(long regNumber) const {return
                      m_statusReg[regNumber]; };

	//! Accessor function to get a command register.
	unsigned long getCommandReg(long regNumber) const {return
                      m_commandReg[regNumber]; };

        //! Accessor function to get the Primitive state
        PrimState getPrimState() const {return m_primState;};
        
        //! Accessor function to get the Text state
        TextBuffState getTextState() const {return m_textState;};
        
                      
// Methods
        void snapShot(RodModule& rod); 
              
private:
    //! The ROD serial number. 
	unsigned long m_serialNumber;
    //! The ROD slot number
        unsigned long m_slotNumber;
    //! The number of slave DSPs installed
        unsigned long m_numSlaves;
    //! The status registers.
	unsigned long m_statusReg[3];
    //! The command registers.
	unsigned long m_commandReg[2];
    //! The state of the Primitive transfer operation
        PrimState m_primState;
    //! The state of the Text buffer transfer operation
        TextBuffState m_textState;

  };                                   // End of RodStatus declaration
}; // End namespace SctPixelRod

#endif  // SCTPIXELROD_RODSTATUS_H
