/*
 * NameCompleter.java
 *
 * Created on 10 December 2002, 12:31
 */

package GuiComponents.scripting;
import java.util.List;

/**
 * Classes that implement this interface are used to help the interpreter complete a name.
 * Typically called after the user has pressed the TAB key.  None of these methods may return null.
 * @author Matthew Palmer
 */
public interface NameCompleter {
    /**
     *This function is called whenever the owner wants to complete a string.
     *The parameter context can be used to determine context.  For instance, typing:
     *"import java.la<TAB>" would give context = "import" and part = "java.la".
     *
     * @return A List of possible completions.  Should only contain Strings.
     * @param context The text preceding the string to be completed.
     * @param part The substring to be completed
     *
     */
    public List completeName(String context, String part);
    
    /**
     * This function returns a list of help Strings.  It is intended to be used to help
     * the user when calling a function/method by providing an argument list.
     * @return a List of helpful Strings
     * @param method The method string
     */
    public List provideHelp(String method);
}
