/*
 * BeanshellInterpreter.java
 *
 * Created on 29 November 2002, 10:28
 */

package GuiComponents.scripting;
import GuiComponents.Console.*;
import bsh.*;
import org.apache.bsf.*;

/**
 *
 * @author  palmer
 */
public class BeanShellInterpreter extends DefaultInterpreter {
    
    /** Creates a new instance of BeanshellInterpreter */
    public BeanShellInterpreter(JConsole console, BSFEngine engine, NameCompleter nc) {
        super (console, engine, nc);
    }
        
    /** Should be overridden to return false when executing a line that returns void.
     *
     */
    protected boolean printObject(Object val) {
        if (val == null) return false;
        if (val instanceof Primitive && ((Primitive)val).equals(Primitive.NULL)) return false;
        return true;
    }
    
    public String toString() {
        return "BeanshellInterpreter";
    }    
}
