package GuiComponents.SctConf;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import javax.swing.event.MouseInputAdapter;

import org.omg.CORBA.IntHolder;
import org.omg.CORBA.StringHolder;

import sctConf.*;
import Sct.gui.SelectionDialog;

public class RODView extends JPanel {
    sctConf.Configuration config;
    Proxies.RodProxy rod;

    public RODView(Configuration conf, Proxies.RodProxy r) {
        rod = r;
        config = conf;

        buildGUI();
    }

    void buildGUI() {
        removeAll();

        setLayout(new BorderLayout());

        JPanel buttons = new JPanel();

        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    ((Window)getTopLevelAncestor()).dispose();
                }
            });
        buttons.add(close);

        add(buttons, BorderLayout.SOUTH);

        JPanel centre = new JPanel();
        centre.setLayout(new GridLayout(2, 4));
        for(int i=0; i<8; i++) {
            MURPanelBrief murPanel = new MURPanelBrief(config, rod, i);

            centre.add(murPanel);
        }

        add(centre, BorderLayout.CENTER);

        Box top = Box.createHorizontalBox();

        try {
            RodConfig rConf = config.getRodConfig(rod.partition(), rod.crate(), rod.index());

            Box labels = Box.createVerticalBox();
            labels.add(new JLabel("BaseAddress:"));
            labels.add(new JLabel("IPRAM:"));
            labels.add(new JLabel("IDRAM:"));
            labels.add(new JLabel("EXT:"));
            top.add(labels);

            Box values = Box.createVerticalBox();
            values.add(new JLabel("0x" + Long.toHexString(rConf.baseAddress)));
            values.add(new JLabel(rConf.slaves[0].ipramFile));
            values.add(new JLabel(rConf.slaves[0].idramFile));
            values.add(new JLabel(rConf.slaves[0].extFile));
            top.add(values);
        } catch (ConfigurationException c) {
            top.add(new JLabel("No Rod configuration information"));
        }

        top.add(getEditButton());
        add(top, BorderLayout.NORTH);
        validate();
    }

    JButton getEditButton() {
        JButton button = new JButton("Edit ROD configuration");
        button.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    String [] labels = {"Base address",
                                        "IPRAM (filename)", "IDRAM (filename)", "xcode (filename)"};
                    String [] defaults = {"0x00000000",
                                          "slaveRun_IPRAM.bin", "slaveRun_IDRAM.bin", "slaveRun_xcode.bin"};

                    SelectionDialog dia = new SelectionDialog(null, "Edit ROD info", labels, defaults);

                    dia.pack();
                    dia.setVisible(true);

                    try {
                        for(int i=0; i<1; i++) {
                            System.out.println(labels[i] + ": " + dia.getIntFieldValue(i));
                        }

                        for(int i=1; i<4; i++) {
                            System.out.println(labels[i] + ": " + dia.getStringFieldValue(i));
                        }

                        try {
                            sctConf.RodConfig rodConf = new sctConf.RodConfig();
                            rodConf.baseAddress = dia.getIntFieldValue(0);

                            rodConf.slaves = new sctConf.SlaveConfig[4];
                            for(int s=0; s<4; s++) {
                                rodConf.slaves[s] = new sctConf.SlaveConfig();
                                rodConf.slaves[s].ipramFile = dia.getStringFieldValue(1);
                                rodConf.slaves[s].idramFile = dia.getStringFieldValue(2);
                                rodConf.slaves[s].extFile = dia.getStringFieldValue(3);
                            }
                            
                            config.configureROD(rod.partition(), rod.crate(), rod.index(), rodConf);

                            System.out.println("ROD configured");
                        } catch(ConfigurationException cex) {
                            JOptionPane.showMessageDialog(null, "Failed to configure ROD: " + cex.detail);
                            return;
                        }

                        buildGUI();
                        System.out.println("GUI rebuilt");
                    } catch(SelectionDialog.InvalidDialogException i) {
                        JOptionPane.showMessageDialog(null, "Failed to interpret entry(ies)");
                    } catch(SelectionDialog.CancelledDialogException i) {
                        // Cancel pressed?
                    }
                    System.out.println("Finished actionPerformed");
                }
            });

        return button;
    }
}
