/*
 * TimDiagnostics.java
 *
 * Created on 03 June 2004, 09:42
 */

package GuiComponents.SctApi;

/**
 *
 * @author  gallop
 */
public class TimDiagnostics extends javax.swing.JPanel {
    TimTableModel tableModel;

    int partition;
    int crate;

    Sct_SctApi.SctApi api;
    
    /** Creates new form TimDiagnostics (for beanability) */
    public TimDiagnostics() {
        initComponents();
    }
    
    /** Creates new form TimDiagnostics */
    public TimDiagnostics(int p, int c, Sct_SctApi.SctApi a) {
        partition = p;
        crate = c;
        api = a;

        initComponents();
//        modifyComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel2 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jTextField2 = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jTextField3 = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();

        setLayout(new java.awt.BorderLayout());

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.X_AXIS));

        jLabel3.setText("Partition");
        jPanel2.add(jLabel3);

        jTextField2.setEditable(false);
        jTextField2.setText(new Integer(getPartition()).toString());
        jPanel2.add(jTextField2);

        jLabel4.setText("Crate");
        jPanel2.add(jLabel4);

        jTextField3.setEditable(false);
        jTextField3.setText(new Integer(getCrate()).toString());
        jPanel2.add(jTextField3);

        add(jPanel2, java.awt.BorderLayout.NORTH);

        jTable1.setModel(getTimTableModel());
        jScrollPane1.setViewportView(jTable1);

        jPanel1.add(jScrollPane1);

        add(jPanel1, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    int getPartition() {
        return partition;
    }

    int getCrate() {
        return crate;
    }

    TimTableModel getTimTableModel() {
        if(tableModel == null)
            tableModel = new TimTableModel();
        return tableModel;
    }

    static final String timRegNames[] = {
        "Enables", "Command", "Burst Count", "Frequency", 
        "Window", "Delay", "Status", "FIFO", 
        "Trigger IDlo", "Trigger IDhi", "Trigger Bunch", "Trigger Type", 
        "Run Enables", "Sequencer", "Sequencer End", "ROD mask", 
        "ROD BUSY", "ROD latch", "ROD Monitor", "TTC Data", 
        "TTC Select", "TTC BCID", "TTCrx Access", "TTC status", 
        "TIM Output", "TIM ID"
    };


    public class TimTableModel extends javax.swing.table.AbstractTableModel {
        String [] dataArray;

        public TimTableModel() {
            // dataArray = block;
        }

        public void newData(String [] data) {
            dataArray = data;
            fireTableDataChanged();
        }
        
        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return 32;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch(columnIndex) {
                case 0: return "" + (rowIndex * 2);
                case 1: return timRegNames[rowIndex];
                case 2: return "0x" + api.timReadRegister(partition, crate, (short)rowIndex);
                default: return "---";
            }
        }
        
        public String getColumnName(int columnIndex) {
            String retValue;

            switch(columnIndex) {
            case 0: retValue = "Address"; break;
            case 1: retValue = "Name"; break;
            case 2: retValue = "Value"; break;
            default: retValue = "Unkown"; break;
            }

            return retValue;
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextField3;
    // End of variables declaration//GEN-END:variables
    
}
