package GuiComponents.SctApi;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import Sct_SctApi.ScanPackage.ScanOptions;

public class ScanView extends JPanel {
    Sct_SctApi.SctApi api;
    Sct_SctApi.Scan scan;

    public ScanView(Sct_SctApi.SctApi a, Sct_SctApi.Scan scn) {
        api = a;
        scan = scn;

        initComponents();
        updateComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel3 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jButton11 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        jButton4 = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jLabel8 = new javax.swing.JLabel();
        scanType1Combo = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();
        start1Value = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        stop1Value = new javax.swing.JTextField();
        jLabel10 = new javax.swing.JLabel();
        step1Value = new javax.swing.JTextField();
        jButton5 = new javax.swing.JButton();
        jButton6 = new javax.swing.JButton();
        jPanel5 = new javax.swing.JPanel();
        jLabel11 = new javax.swing.JLabel();
        scanType2Combo = new javax.swing.JComboBox();
        jLabel4 = new javax.swing.JLabel();
        start2Value = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        stop2Value = new javax.swing.JTextField();
        jLabel13 = new javax.swing.JLabel();
        step2Value = new javax.swing.JTextField();
        jButton7 = new javax.swing.JButton();
        jButton8 = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        numTrigsValue = new javax.swing.JTextField();
        jLabel15 = new javax.swing.JLabel();
        bitsValue = new javax.swing.JTextField();
        jLabel16 = new javax.swing.JLabel();
        calLineValue = new javax.swing.JTextField();
        jLabel17 = new javax.swing.JLabel();
        slaveDistValue = new javax.swing.JTextField();
        jLabel14 = new javax.swing.JLabel();
        timValue = new javax.swing.JTextField();
        jButton9 = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        scanPointsList = new javax.swing.JList();

        setLayout(new java.awt.BorderLayout());

        jButton1.setText("Print Scan");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                printScanActionPerformed(evt);
            }
        });

        jPanel3.add(jButton1);

        jButton2.setText("Execute Scan");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                executeScanActionPerformed(evt);
            }
        });

        jPanel3.add(jButton2);

        jButton11.setText("Execute Raw Scan");
        jButton11.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                executeRawScanPerformed(evt);
            }
        });

        jPanel3.add(jButton11);

        jButton3.setText("Close");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeActionPerformed(evt);
            }
        });

        jPanel3.add(jButton3);

        jButton4.setText("Destroy");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                destroyActionPerformed(evt);
            }
        });

        jPanel3.add(jButton4);

        add(jPanel3, java.awt.BorderLayout.SOUTH);

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.Y_AXIS));

        jPanel4.setLayout(new javax.swing.BoxLayout(jPanel4, javax.swing.BoxLayout.X_AXIS));

        jLabel8.setText("Scan type 1");
        jPanel4.add(jLabel8);

        scanType1Combo.setModel(new DefaultComboBoxModel(getScanList()));
        jPanel4.add(scanType1Combo);

        jLabel3.setText("Start scan 1 value");
        jPanel4.add(jLabel3);

        start1Value.setText("0.0");
        jPanel4.add(start1Value);

        jLabel9.setText("Stop scan 1 value");
        jPanel4.add(jLabel9);

        stop1Value.setText("100.0");
        jPanel4.add(stop1Value);

        jLabel10.setText("Step scan 1 value");
        jPanel4.add(jLabel10);

        step1Value.setText("10.0");
        jPanel4.add(step1Value);

        jButton5.setText("Update scan 1");
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                updateScan1Performed(evt);
            }
        });

        jPanel4.add(jButton5);

        jButton6.setText("Edit Trigger 1");
        jButton6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editTrigger1Performed(evt);
            }
        });

        jPanel4.add(jButton6);

        jPanel1.add(jPanel4);

        jPanel5.setLayout(new javax.swing.BoxLayout(jPanel5, javax.swing.BoxLayout.X_AXIS));

        jLabel11.setText("Scan type 2");
        jPanel5.add(jLabel11);

        scanType2Combo.setModel(new DefaultComboBoxModel(getScanList()));
        jPanel5.add(scanType2Combo);

        jLabel4.setText("Start scan 2 value");
        jPanel5.add(jLabel4);

        start2Value.setText("0.0");
        jPanel5.add(start2Value);

        jLabel12.setText("Stop scan 2 value");
        jPanel5.add(jLabel12);

        stop2Value.setText("100.0");
        jPanel5.add(stop2Value);

        jLabel13.setText("Step scan 2 value");
        jPanel5.add(jLabel13);

        step2Value.setText("10.0");
        jPanel5.add(step2Value);

        jButton7.setText("Update scan 2");
        jButton7.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                updateScan2Performed(evt);
            }
        });

        jPanel5.add(jButton7);

        jButton8.setText("Edit Trigger 2");
        jButton8.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editTrigger2Performed(evt);
            }
        });

        jPanel5.add(jButton8);

        jPanel1.add(jPanel5);

        jPanel6.setLayout(new javax.swing.BoxLayout(jPanel6, javax.swing.BoxLayout.X_AXIS));

        jLabel5.setText("No. Triggers");
        jPanel6.add(jLabel5);

        numTrigsValue.setText("100");
        jPanel6.add(numTrigsValue);

        jLabel15.setText("Bits32");
        jPanel6.add(jLabel15);

        bitsValue.setText("1");
        jPanel6.add(bitsValue);

        jLabel16.setText("Loop over cal-line");
        jPanel6.add(jLabel16);

        calLineValue.setText("0");
        jPanel6.add(calLineValue);

        jLabel17.setText("Slave distribution");
        jPanel6.add(jLabel17);

        slaveDistValue.setText("0");
        jPanel6.add(slaveDistValue);

        jLabel14.setText("Use TIM");
        jPanel6.add(jLabel14);

        timValue.setText("0");
        jPanel6.add(timValue);

        jButton9.setText("Update");
        jButton9.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                optionsUpdatePerformed(evt);
            }
        });

        jPanel6.add(jButton9);

        jPanel1.add(jPanel6);

        add(jPanel1, java.awt.BorderLayout.CENTER);

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.Y_AXIS));

        jLabel1.setText("Scan variable 1 " + getScanVariable1());
        jPanel2.add(jLabel1);

        jLabel2.setText("Scan variable 1 " + getScanVariable2());
        jPanel2.add(jLabel2);

        jLabel6.setText("Number of triggers " + getTriggerCount());
        jPanel2.add(jLabel6);

        jLabel7.setText(getOptionsString());
        jPanel2.add(jLabel7);

        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        scanPointsList.setModel(getListModel());
        jScrollPane1.setViewportView(scanPointsList);

        jPanel2.add(jScrollPane1);

        add(jPanel2, java.awt.BorderLayout.NORTH);

    }//GEN-END:initComponents

    private void executeRawScanPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_executeRawScanPerformed
        try {
            // 1 is delay, don't configure, don't use clk/2 mode
            api.doRawScan(scan, 1, 768, false, false);
        } catch(Sct_SctApi.SctApiException s) {
            JOptionPane.showMessageDialog(null, "Exception processing doRawScan " + s.detail);
        }
    }//GEN-LAST:event_executeRawScanPerformed
        
    void updateComponents() {
    }


    private void editTrigger2Performed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editTrigger2Performed
        TriggerSelect dia = new TriggerSelect(api, scan.getTrigger2());

        dia.pack();
        dia.setVisible(true);

        dia.modifyTrigger();

        dia.dispose();
//                     updateInfoPanel();
    }//GEN-LAST:event_editTrigger2Performed

    private void editTrigger1Performed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editTrigger1Performed
        TriggerSelect dia = new TriggerSelect(api, scan.getTrigger1());

        dia.pack();
        dia.setVisible(true);

        dia.modifyTrigger();

        dia.dispose();
//                     updateInfoPanel();
    }//GEN-LAST:event_editTrigger1Performed

    private void optionsUpdatePerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_optionsUpdatePerformed
        short ntrigs = Short.parseShort(numTrigsValue.getText());
        scan.setNTrigs(ntrigs);
        short bits32 = Short.parseShort(bitsValue.getText());
        scan.setOption(ScanOptions.bits32, bits32);
        short loopCalLine = Short.parseShort(calLineValue.getText());
        scan.setOption(ScanOptions.loopCalLine, loopCalLine);
        short distSlave = Short.parseShort(slaveDistValue.getText());
        scan.setOption(ScanOptions.distSlave, distSlave);
        short tim = Short.parseShort(timValue.getText());
        scan.setOption(ScanOptions.tim, tim);

//        updateInfoPanel();
    }//GEN-LAST:event_optionsUpdatePerformed

    private void updateScan2Performed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_updateScan2Performed
        short type = (short)Sct.ScanDescriptors.getInstance().valueFor((String)scanType2Combo.getSelectedItem());
        double start = Double.parseDouble(start2Value.getText());
        double stop = Double.parseDouble(stop2Value.getText());
        double step = Double.parseDouble(step2Value.getText());

        System.out.println("Configuring scan 2 with " + type + " " + start + " " + stop + " " + step);
        scan.configure2(type, start, stop, step);
    }//GEN-LAST:event_updateScan2Performed

    private void updateScan1Performed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_updateScan1Performed
        short type = (short)Sct.ScanDescriptors.getInstance().valueFor((String)scanType1Combo.getSelectedItem());
        double start = Double.parseDouble(start1Value.getText());
        double stop = Double.parseDouble(stop1Value.getText());
        double step = Double.parseDouble(step1Value.getText());

        System.out.println("Configuring scan with " + type + " " + start + " " + stop + " " + step);
        scan.configure(type, start, stop, step);
//        updateInfoPanel();
    }//GEN-LAST:event_updateScan1Performed

    private void destroyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_destroyActionPerformed
        scan.destroy();
        ((Window)getTopLevelAncestor()).dispose();
    }//GEN-LAST:event_destroyActionPerformed

    private void closeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeActionPerformed
        ((Window)getTopLevelAncestor()).dispose();
    }//GEN-LAST:event_closeActionPerformed

    private void executeScanActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_executeScanActionPerformed
        try {
            api.doScan(scan);
        } catch(Sct_SctApi.SctApiException s) {
            JOptionPane.showMessageDialog(null, "Exception processing doScan " + s.detail);
        }
    }//GEN-LAST:event_executeScanActionPerformed

    private void printScanActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_printScanActionPerformed
        scan.print();
    }//GEN-LAST:event_printScanActionPerformed
    
    String [] getScanPointsList() {
        double [] realPoints = scan.getScanPoints1();

        String [] myPoints = new String[realPoints.length];

        for(int i=0; i<realPoints.length; i++) {
            myPoints[i] = new String("" + realPoints[i]);
        }

        return myPoints;
    }
    
    public String getScanVariable1() {
        return "" + scan.getScanVariable1();
    }
    
    public String getScanVariable2() {
        return "" + scan.getScanVariable2();
    }
    
    public int getTriggerCount() {
        return scan.getNTrigs();
    }
    
    public String getOptionsString() {
        String flagString = "";

        flagString += " full: " + scan.getOption(ScanOptions.full);
        flagString += " bits32: " + scan.getOption(ScanOptions.bits32);
        flagString += " loopCalLine: " + scan.getOption(ScanOptions.loopCalLine);
        flagString += " distSlave: " + scan.getOption(ScanOptions.distSlave);
        flagString += " debug: " + scan.getOption(ScanOptions.debug);
        flagString += " tim: " + scan.getOption(ScanOptions.tim);

        return flagString;
    }
    
    public String[] getScanList() {
        return Sct.ScanDescriptors.getInstance().listDescriptors();
    }
    
    public ListModel getListModel() {
        return new SimpleArrayListModel(getScanPointsList());
    }

    class SimpleArrayListModel extends AbstractListModel {
        Object [] myArray;

        SimpleArrayListModel(Object [] array) {
            myArray = array;
        }

        void changeData(Object [] array) {
            myArray = array;
            fireContentsChanged(this, 0, myArray.length);
        }
        
        public Object getElementAt(int index) {
            return myArray[index];
        }
        
        public int getSize() {
            return myArray.length;
        }
        
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField bitsValue;
    private javax.swing.JTextField calLineValue;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton11;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JButton jButton7;
    private javax.swing.JButton jButton8;
    private javax.swing.JButton jButton9;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField numTrigsValue;
    private javax.swing.JList scanPointsList;
    private javax.swing.JComboBox scanType1Combo;
    private javax.swing.JComboBox scanType2Combo;
    private javax.swing.JTextField slaveDistValue;
    private javax.swing.JTextField start1Value;
    private javax.swing.JTextField start2Value;
    private javax.swing.JTextField step1Value;
    private javax.swing.JTextField step2Value;
    private javax.swing.JTextField stop1Value;
    private javax.swing.JTextField stop2Value;
    private javax.swing.JTextField timValue;
    // End of variables declaration//GEN-END:variables
}
