package GuiComponents.SctApi;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.table.TableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.JTableHeader;

public class ProbeView extends JPanel {
    Sct_SctApi.SctApi api;

    int partition;
    int crate;
    int rod;

    ResultsTableModel tableModel;
    
    short [] results;
    short [][] scanResults;

    public ProbeView(int p, int c, int r, Sct_SctApi.SctApi a) {
        partition = p;
        crate = c;
        rod = r;
        api = a;

        tableModel = new ProbeView.ResultsTableModel();
        results = api.probeHarness(partition, crate, rod, 0);
        scanResults = new short[0][0];
        initComponents();
        modifyComponents();
    }

    // For beanability
    public ProbeView() {
        initComponents();
        results = api.probeHarness(0, 0, 0, 0);
        modifyComponents();
    }

    public void modifyComponents() {
        updateResultsPanel();

        int columnWidth = jTable1.getFontMetrics(jTable1.getFont()).stringWidth("mmmmmm");

        // Enough to see "link 48"
        TableColumn column = jTable1.getColumnModel().getColumn(0);
        column.setPreferredWidth(columnWidth * 8);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel2 = new javax.swing.JPanel();
        jPanel5 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jTextField2 = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jTextField3 = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jTextField4 = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        harnessValue = new javax.swing.JTextField();
        jPanel6 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        checkCharsText = new javax.swing.JTextField();
        checkProbePerformed = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jButton4 = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        resultsPanel = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jComboBox1 = new javax.swing.JComboBox();
        jButton2 = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel7 = new javax.swing.JPanel();
        jPanel8 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jComboBox2 = new javax.swing.JComboBox();
        jLabel6 = new javax.swing.JLabel();
        jComboBox3 = new javax.swing.JComboBox();
        loopbackTestPerform = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable2 = new javax.swing.JTable();

        setLayout(new java.awt.BorderLayout());

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.Y_AXIS));

        jPanel5.setLayout(new javax.swing.BoxLayout(jPanel5, javax.swing.BoxLayout.X_AXIS));

        jLabel3.setText("Partition");
        jPanel5.add(jLabel3);

        jTextField2.setEditable(false);
        jTextField2.setText(new Integer(getPartition()).toString());
        jPanel5.add(jTextField2);

        jLabel4.setText("Crate");
        jPanel5.add(jLabel4);

        jTextField3.setEditable(false);
        jTextField3.setText(new Integer(getCrate()).toString());
        jPanel5.add(jTextField3);

        jLabel5.setText("ROD");
        jPanel5.add(jLabel5);

        jTextField4.setEditable(false);
        jTextField4.setText(new Integer(getRod()).toString());
        jPanel5.add(jTextField4);

        jLabel7.setText("Harness");
        jPanel5.add(jLabel7);

        harnessValue.setText("0");
        jPanel5.add(harnessValue);

        jPanel2.add(jPanel5);

        jPanel6.setLayout(new javax.swing.BoxLayout(jPanel6, javax.swing.BoxLayout.X_AXIS));

        jButton1.setText("Probe");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                probeButtonPerformed(evt);
            }
        });

        jPanel6.add(jButton1);

        checkCharsText.setText("2E");
        jPanel6.add(checkCharsText);

        checkProbePerformed.setText("Check Modules Probe");
        checkProbePerformed.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                checkProbePerformedActionPerformed(evt);
            }
        });

        jPanel6.add(checkProbePerformed);

        jPanel2.add(jPanel6);

        add(jPanel2, java.awt.BorderLayout.NORTH);

        jPanel1.setOpaque(false);
        jButton4.setText("Close");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonPerformed(evt);
            }
        });

        jPanel1.add(jButton4);

        add(jPanel1, java.awt.BorderLayout.SOUTH);

        resultsPanel.setLayout(new javax.swing.BoxLayout(resultsPanel, javax.swing.BoxLayout.Y_AXIS));

        jTabbedPane1.addTab("Single Probe", resultsPanel);

        jPanel3.setLayout(new java.awt.BorderLayout());

        jPanel4.setLayout(new javax.swing.BoxLayout(jPanel4, javax.swing.BoxLayout.X_AXIS));

        jLabel1.setText("Scan type");
        jPanel4.add(jLabel1);

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "default", "Loopback Scan" }));

        jPanel4.add(jComboBox1);

        jButton2.setText("Perform scan");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                performScanActionPerformed(evt);
            }
        });

        jPanel4.add(jButton2);

        jPanel3.add(jPanel4, java.awt.BorderLayout.NORTH);

        jTable1.setFont(new java.awt.Font("Monospaced", 0, 12));
        jTable1.setModel(getScanResultsTableModel());
        jScrollPane1.setViewportView(jTable1);

        jPanel3.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jTabbedPane1.addTab("Probe Scan", jPanel3);

        jPanel7.setLayout(new java.awt.BorderLayout());

        jPanel8.setLayout(new javax.swing.BoxLayout(jPanel8, javax.swing.BoxLayout.X_AXIS));

        jLabel2.setText("Scan type");
        jPanel8.add(jLabel2);

        jComboBox2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "default", "Loopback Scan" }));
        jPanel8.add(jComboBox2);

        jLabel6.setText("Select Line");
        jPanel8.add(jLabel6);

        jComboBox3.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Normal", "Redundant" }));
        jPanel8.add(jComboBox3);

        loopbackTestPerform.setText("Perform scan");
        loopbackTestPerform.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loopbackTestPerformActionPerformed(evt);
            }
        });

        jPanel8.add(loopbackTestPerform);

        jPanel7.add(jPanel8, java.awt.BorderLayout.NORTH);

        jTable2.setFont(new java.awt.Font("Monospaced", 0, 12));
        jTable2.setModel(getScanResultsTableModel());
        jScrollPane2.setViewportView(jTable2);

        jPanel7.add(jScrollPane2, java.awt.BorderLayout.CENTER);

        jTabbedPane1.addTab("Loopback test", jPanel7);

        add(jTabbedPane1, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    private void loopbackTestPerformActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loopbackTestPerformActionPerformed
        // Set up scan 
        Sct_SctApi.Scan probeScan = api.createScan();
        probeScan.getTrigger1().doubleL1A((short)10);
        probeScan.configure((short)20, 0.0, 24.0, 1.0);
        // Perform probe Scan
        try {
            scanResults = api.probeScanHarnessWithTrigger(getPartition(), getCrate(), getRod(), probeScan, 
                                                          Integer.parseInt(harnessValue.getText()));
            // updateLoopbackScanResults();
        } catch(NumberFormatException e) {
            javax.swing.JOptionPane.showMessageDialog(null, "Failed to interpet harness value");
        }
    }//GEN-LAST:event_loopbackTestPerformActionPerformed

    private void checkProbePerformedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_checkProbePerformedActionPerformed
        try  {
            if(api.checkAllModulesProbe(checkCharsText.getText())) {
                JOptionPane.showMessageDialog(null, "Check modules succeeded");
            } else {
                JOptionPane.showMessageDialog(null, "Check modules failed, see MRS for details");
            }
        } catch(Sct_SctApi.SctApiException s) {
            JOptionPane.showMessageDialog(null, "Check modules aborted: " + s);
        }
    }//GEN-LAST:event_checkProbePerformedActionPerformed

    private void performScanActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_performScanActionPerformed
        // Set up scan 
        Sct_SctApi.Scan probeScan = api.createScan();
        probeScan.getTrigger1().doubleL1A((short)10);
        probeScan.configure((short)20, 0.0, 24.0, 1.0);
        // Perform probe Scan
        try {
            scanResults = api.probeScanHarnessWithTrigger(getPartition(), getCrate(), getRod(), probeScan, 
                                                          Integer.parseInt(harnessValue.getText()));
            updateScanResults();
        } catch(NumberFormatException e) {
            javax.swing.JOptionPane.showMessageDialog(null, "Failed to interpet harness value");
        }
    }//GEN-LAST:event_performScanActionPerformed

    private void probeButtonPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_probeButtonPerformed
        int partition = getPartition();
        int crate = getCrate();
        int rod = getRod();
        int harness;
        try {
            harness = Integer.parseInt(harnessValue.getText());
        } catch(NumberFormatException e) {
            harness = -1;
        }

        if(harness == -1) {
            results  = api.probe(partition, crate, rod);
        } else {
            results  = api.probeHarness(partition, crate, rod, harness);
        }

        updateResultsPanel();
    }//GEN-LAST:event_probeButtonPerformed

    private void closeButtonPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonPerformed
        ((Window)getTopLevelAncestor()).dispose();
    }//GEN-LAST:event_closeButtonPerformed

    void updateResultsPanel() {
        resultsPanel.removeAll();
        for(int i=0; i<results.length; i++) {
	    resultsPanel.add(new JLabel("" + (char)results[i]));
	}

        resultsPanel.invalidate();
        validate();
    }

    TableModel getScanResultsTableModel() {
        return tableModel;
    }
    
    void updateScanResults() {
        tableModel.newData();
    }

    public int getPartition() {
        return partition;
    }

    public int getCrate() {
        return crate;
    }

    public int getRod() {
        return rod;
    }

    class ResultsTableModel extends javax.swing.table.AbstractTableModel {
        public ResultsTableModel() {
        }

        public void newData() {
            fireTableStructureChanged();
        }
        
        public int getColumnCount() {
            return 1+scanResults.length;
        }

        public int getRowCount() {
            if(scanResults.length > 0) {
                return scanResults[0].length;
            } else {
                return 0;
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if(columnIndex == 0) {
                return "Link " + rowIndex;
            } else {
                return "" + (char)scanResults[columnIndex-1][rowIndex];
            }
        }

        public String getColumnName(int columnIndex) {
            String retValue;
            
            if(columnIndex == 0) {
                retValue = "";
            } else {
                columnIndex--;
                retValue = "" + columnIndex;
            }

            return retValue;
        }
    }    

    class LoopbackResultsTableModel extends ResultsTableModel {
        public String getColumnName(int columnIndex) {
            if(columnIndex == 25) {
                return "Pass/Fail";
            } else {
                return ((ResultsTableModel)this).getColumnName(columnIndex);
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if(columnIndex == 25) {
                for(int clk=0; clk<24; clk++) {
                    int i = (char)scanResults[clk][rowIndex];
                }

                return "Unimplemented";
            } else {
                return ((ResultsTableModel)this).getValueAt(rowIndex, columnIndex);
            }
        }

    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField checkCharsText;
    private javax.swing.JButton checkProbePerformed;
    private javax.swing.JTextField harnessValue;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton4;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JComboBox jComboBox2;
    private javax.swing.JComboBox jComboBox3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTable jTable2;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextField3;
    private javax.swing.JTextField jTextField4;
    private javax.swing.JButton loopbackTestPerform;
    private javax.swing.JPanel resultsPanel;
    // End of variables declaration//GEN-END:variables
}
