/*
 * ModuleConfigurations.java
 *
 * Created on 07 January 2004, 14:12
 */

package GuiComponents.SctApi;

import java.awt.Window;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumn;
import javax.swing.table.JTableHeader;

import Sct_SctApi.SctApi;

import Sct.SerializableWrapper;
import SctData.ModuleConfiguration;

/**
 * Panel for low level Module configuration examinations and modification
 *
 * @author  gallop
 */
public class ModuleConfigurations extends JPanel implements java.io.Serializable {
    BlockTableModel bTableModel;

    int partition;
    int crate;
    int rod;
    Sct_SctApi.SctApi api;
    
    /** Make it beanable... */
    public ModuleConfigurations() {
        initComponents();
        modifyComponents();
    }

    /** Creates new form ModuleConfigurations */
    public ModuleConfigurations(int p, int c, int r, Sct_SctApi.SctApi a) {
        partition = p;
        crate = c;
        rod = r;
        api = a;

        initComponents();
        modifyComponents();
    }

    public static void main(String [] args) {
        javax.swing.JFrame f = new javax.swing.JFrame("ROD Diag test");
        
        ModuleConfigurations conf = new ModuleConfigurations();

        f.getContentPane().add(conf);
        f.pack();
        f.setVisible(true);

        sctConf.ABCDConfig bConfig = new sctConf.ABCDConfig((short)0);

        short sz = (short)0;
        byte bz = (byte)0;
        
        int mask[] = {0, 0xffff, 0xffffffff, 3};
        sctConf.ABCDBasic basic = new sctConf.ABCDBasic(bConfig, sz, bz, bz, bz, bz, bz, mask);

        float rc[] = {0.0f, 0.0f, 0.0f};
        int dummy[] = {0, 0};
        sctConf.ABCDCaldata data = new sctConf.ABCDCaldata(bz, rc, 1.0f, dummy);

        byte trims[] = {0};
        sctConf.ABCDChip chip = new sctConf.ABCDChip(bz, bz, bz, bz, basic, data, trims);
        byte rxs[] = {2, 3};
        byte bdummy[] = {0, 0};
        sctConf.ABCDModule newConfig = new sctConf.ABCDModule(null, bz, bz, bz, bz, 0, bz, bz, rxs, bdummy, dummy);
        newConfig.chip = new sctConf.ABCDChip[12];
        for(int i=0; i<12; i++) {
            newConfig.chip[i] = chip;
        }
        
        if(newConfig != null) {
            conf.inspectorPanel1.setData(new SerializableWrapper(new ModuleConfiguration(newConfig), "no serial number", "ModuleConfiguration"));
        }
    }

    
    void modifyComponents() {
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel2 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jTextField2 = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jTextField3 = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jTextField4 = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jTextField6 = new javax.swing.JTextField();
        jPanel3 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        slotText = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        bankCombo = new javax.swing.JComboBox();
        jButton5 = new javax.swing.JButton();
        jPanel5 = new javax.swing.JPanel();
        jLabel11 = new javax.swing.JLabel();
        currBankLabel = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        currSlotLabel = new javax.swing.JLabel();
        inspectorPanel1 = new GuiComponents.Inspector.InspectorPanel();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        varTypeCombo = new javax.swing.JComboBox();
        varValueText = new javax.swing.JTextField();
        changeButton = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.X_AXIS));

        jLabel3.setText("Partition");
        jPanel2.add(jLabel3);

        jTextField2.setEditable(false);
        jTextField2.setText(new Integer(getPartition()).toString());
        jPanel2.add(jTextField2);

        jLabel4.setText("Crate");
        jPanel2.add(jLabel4);

        jTextField3.setEditable(false);
        jTextField3.setText(new Integer(getCrate()).toString());
        jPanel2.add(jTextField3);

        jLabel5.setText("ROD");
        jPanel2.add(jLabel5);

        jTextField4.setEditable(false);
        jTextField4.setText(new Integer(getROD()).toString());
        jPanel2.add(jTextField4);

        jLabel7.setText("Slot");
        jPanel2.add(jLabel7);

        jTextField6.setEditable(false);
        jTextField6.setText(getRODSlot());
        jPanel2.add(jTextField6);

        add(jPanel2, java.awt.BorderLayout.NORTH);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jPanel4.setLayout(new java.awt.GridBagLayout());

        jLabel2.setText("Module Slot");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        jPanel4.add(jLabel2, gridBagConstraints);

        slotText.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.1;
        jPanel4.add(slotText, gridBagConstraints);

        jLabel8.setText("Module bank");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        jPanel4.add(jLabel8, gridBagConstraints);

        bankCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Physics", "Calibration", "Scan", "SctApi", "Configuration" }));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        jPanel4.add(bankCombo, gridBagConstraints);

        jButton5.setText("Get Module Configuration");
        jButton5.setEnabled(isRODValid());
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                getModuleConfigurationActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        jPanel4.add(jButton5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(jPanel4, gridBagConstraints);

        jLabel11.setText("Bank");
        jPanel5.add(jLabel11);

        currBankLabel.setText("-");
        jPanel5.add(currBankLabel);

        jLabel12.setText("Slot");
        jPanel5.add(jLabel12);

        currSlotLabel.setText("0");
        jPanel5.add(currSlotLabel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(jPanel5, gridBagConstraints);

        inspectorPanel1.setMinimumSize(new java.awt.Dimension(50, 40));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        jPanel3.add(inspectorPanel1, gridBagConstraints);

        add(jPanel3, java.awt.BorderLayout.CENTER);

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.X_AXIS));

        jPanel1.setOpaque(false);
        jLabel1.setText("Modify variable");
        jPanel1.add(jLabel1);

        varTypeCombo.setModel(new DefaultComboBoxModel(getScanList()));
        jPanel1.add(varTypeCombo);

        varValueText.setText("0");
        jPanel1.add(varValueText);

        changeButton.setText("Change");
        changeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                changeModuleConfigurationPerformed(evt);
            }
        });

        jPanel1.add(changeButton);

        add(jPanel1, java.awt.BorderLayout.SOUTH);

    }//GEN-END:initComponents

    private void getModuleConfigurationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_getModuleConfigurationActionPerformed
        getModuleConfiguration();
    }
    
    private void getModuleConfiguration() {
        int slot = Long.decode(slotText.getText()).intValue();
        String bank = (String)bankCombo.getSelectedItem();
        sctConf.ABCDModule newConfig = null;
        if(bank.equals("SctApi")) {
            newConfig = api.retrieveModule(api.findModuleRod(getPartition(), getCrate(), getROD(), slot));
        } else if(bank.equals("Configuration")) {
            JOptionPane.showMessageDialog(null, "Unimplemented bank type");
            return;
        } else {
            Sct_SctApi.BankType realBank;
            if(bank.equals("Physics")) {
                realBank = Sct_SctApi.BankType.PHYSICS_CONFIG;
            } else if(bank.equals("Calibration")) {
                realBank = Sct_SctApi.BankType.CALIBRATION_CONFIG;
            } else if(bank.equals("Scan")) {
                realBank = Sct_SctApi.BankType.SCAN_CONFIG;
            } else {
                JOptionPane.showMessageDialog(null, "Unknown bank type");
                return;
            }

            try {
                newConfig = api.getABCDModuleRaw(getPartition(), getCrate(), getROD(), slot, realBank);
            } catch(Sct_SctApi.SctApiException e) {
                JOptionPane.showMessageDialog(null, "Exception thrown by API: " + e.detail);
            }
        }

        if(newConfig != null) {
//             inspectorPanel1 = new GuiComponents.Inspector.InspectorPanel("Module name?", new SerializableWrapper(new ModuleConfiguration(newConfig), "no serial number", "ModuleConfiguration"));
            inspectorPanel1.setData(new SerializableWrapper(new ModuleConfiguration(newConfig), "no serial number", "ModuleConfiguration"));
            // jScrollPane1.setViewportView(inspectorPanel1.treeTable);

            currBankLabel.setText(bank);
            currSlotLabel.setText("" + slot);
        }
    }//GEN-LAST:event_getModuleConfigurationActionPerformed

    private void changeModuleConfigurationPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_changeModuleConfigurationPerformed
        int slot = Long.decode(slotText.getText()).intValue();
        String bank = (String)bankCombo.getSelectedItem();
        short type = (short)Sct.ScanDescriptors.getInstance().valueFor((String)varTypeCombo.getSelectedItem());
        float value = Float.parseFloat(varValueText.getText());

        if(bank.equals("SctApi")) {
            api.modifyABCDModuleVar(api.findModuleRod(getPartition(), getCrate(), getROD(), slot),
                                    type, value);
            getModuleConfiguration();
        } else if(bank.equals("Configuration")) {
            JOptionPane.showMessageDialog(null, "Unimplemented bank type");
            return;
        } else {
            Sct_SctApi.BankType realBank;
            if(bank.equals("Physics")) {
                realBank = Sct_SctApi.BankType.PHYSICS_CONFIG;
            } else if(bank.equals("Calibration")) {
                realBank = Sct_SctApi.BankType.CALIBRATION_CONFIG;
            } else if(bank.equals("Scan")) {
                realBank = Sct_SctApi.BankType.SCAN_CONFIG;
            } else {
                JOptionPane.showMessageDialog(null, "Unknown bank type");
                return;
            }

            api.modifyABCDModuleVarROD(api.findModuleRod(getPartition(), getCrate(), getROD(), slot),
                                       type, value, realBank);
            getModuleConfiguration();
        }
    }//GEN-LAST:event_changeModuleConfigurationPerformed

    public String[] getScanList() {
        return Sct.ScanDescriptors.getInstance().listDescriptors();
    }
    
    public TableModel getBlockTableModel() {
        if(bTableModel == null) {
            int [] nullBlock = {};

            bTableModel = new ModuleConfigurations.BlockTableModel(nullBlock);
        }

        return bTableModel;
    }    
    
    public int getPartition() {
        return partition;
    }

    public int getCrate() {
        return crate;
    }

    public int getROD() {
        return rod;
    }

    public String getRODSlot() {
        try {
            long rodSlot = api.getRodSlot(partition, crate, rod);
            return "" + rodSlot;
        } catch(NullPointerException n) {
            return "No API";
        }
    }

    public boolean isRODValid() {
        if(api == null) {
            if(getTopLevelAncestor() == null) {
                // Doesn't have an ancestor when its being constructed...
                return false;
            } else {
                ((Window)getTopLevelAncestor()).dispose();
                return false;
            }
        } else {
            return api.isRODPresent(partition, crate, rod);
        }
    }

    /** Setter for property partition.
     * @param partition New value of property partition.
     *
     */
    public void setPartition(int partition) { this.partition = partition; }
    
    public class BlockTableModel extends javax.swing.table.AbstractTableModel {
        int [] blockArray;

        public BlockTableModel(int [] block) {
            blockArray = block;
        }

        public void newData(int [] block) {
            blockArray = block;
            fireTableDataChanged();
        }
        
        public int getColumnCount() {
            // 16 + address + ascii version
            return 16+2;
        }

        public int getRowCount() {
            return (blockArray.length+7) / 8;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
/*            System.out.println("r" + rowIndex + ", c" + columnIndex);
            System.out.println(" offset " + (rowIndex*8 + columnIndex) + " len " + blockArray.length);
*/
            if(columnIndex == 0) {
                return Integer.toHexString(rowIndex*32);
            } else if(columnIndex == 17) {
                StringBuffer buff = new StringBuffer();
                
                int offset = rowIndex*8;

                for(int i=0; i<8; i++) {
                    if(offset + i >= blockArray.length) {
                        break;
                    }

                    for(int j=0; j<4; j++) {
                        int ascii = (blockArray[offset + i] >> (8*j)) & 0xff;
                        if(ascii >= 32 && ascii < 128) {
                            buff.append((char)ascii);
                        } else {
                            buff.append(".");
                        }
                    }

                    buff.append(" ");
                }
                return buff.toString();
            } else {
                columnIndex --;
                if((columnIndex/2) + rowIndex*8 >= blockArray.length) {
                    return null;
                } else {
                    int value = blockArray[(columnIndex/2) + rowIndex*8];
                    String hexString = Integer.toHexString(value);
                    if(columnIndex % 2 == 0) {
                        if(hexString.length() > 4) {
                            hexString = hexString.substring(0, hexString.length()-4);
                        } else {
                            hexString = "0000";
                        }
                    } else {
                        if(hexString.length() > 4) {
                            hexString = hexString.substring(hexString.length()-4);
                        } else {
                            // Leave it
                        }
                    }
                    return "0000".substring(0, 4-hexString.length()) + hexString; 
                }
            }
        }
        
        public String getColumnName(int columnIndex) {
            String retValue;
            
            if(columnIndex == 0) {
                retValue = "";
            } else if(columnIndex == 17) {
                retValue = "ASCII";
            } else {
                columnIndex--;
                retValue = Integer.toHexString((columnIndex * 2));
            }

            return retValue;
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox bankCombo;
    private javax.swing.JButton changeButton;
    private javax.swing.JLabel currBankLabel;
    private javax.swing.JLabel currSlotLabel;
    private GuiComponents.Inspector.InspectorPanel inspectorPanel1;
    private javax.swing.JButton jButton5;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextField3;
    private javax.swing.JTextField jTextField4;
    private javax.swing.JTextField jTextField6;
    private javax.swing.JTextField slotText;
    private javax.swing.JComboBox varTypeCombo;
    private javax.swing.JTextField varValueText;
    // End of variables declaration//GEN-END:variables
    
}
